/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.PermissionDeniedException;
import ru.curs.celesta.dbutils.Action;
import ru.curs.celesta.dbutils.BasicDataAccessor;
import ru.curs.celesta.dbutils.IPermissionManager;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.filter.AbstractFilter;
import ru.curs.celesta.dbutils.filter.Filter;
import ru.curs.celesta.dbutils.filter.In;
import ru.curs.celesta.dbutils.filter.Range;
import ru.curs.celesta.dbutils.filter.SingleValue;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.MaskedStatementHolder;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.dbutils.stmt.PreparedStatementHolderFactory;
import ru.curs.celesta.dbutils.stmt.PreparedStmtHolder;
import ru.curs.celesta.dbutils.term.FromTerm;
import ru.curs.celesta.dbutils.term.WhereMakerParamsProvider;
import ru.curs.celesta.dbutils.term.WhereTerm;
import ru.curs.celesta.dbutils.term.WhereTermsMaker;
import ru.curs.celesta.score.CelestaParser;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.validator.IdentifierParser;

public abstract class BasicCursor
extends BasicDataAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicCursor.class);
    private static final String DATABASE_CLOSING_ERROR = "Database error when closing recordset for table '%s': %s";
    private static final String NAVIGATING_ERROR = "Error while navigating cursor: %s";
    private static final Pattern COLUMN_NAME = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)( +([Aa]|[Dd][Ee])[Ss][Cc])?");
    private static final Pattern NAVIGATION = Pattern.compile("[+-<>=]+");
    private static final Pattern NAVIGATION_WITH_OFFSET = Pattern.compile("[<>]");
    protected Set<String> fields = Collections.emptySet();
    protected Set<String> fieldsForStatement = Collections.emptySet();
    protected ResultSet cursor;
    protected FromTerm fromTerm;
    final PreparedStmtHolder set = PreparedStatementHolderFactory.createFindSetHolder((DBAdaptor)this.db(), (Connection)this.conn(), () -> this.getFrom(), () -> {
        if (this.fromTerm == null) {
            this.fromTerm = new FromTerm(this.getFrom().getParameters());
            return this.fromTerm;
        }
        return this.fromTerm;
    }, () -> this.qmaker.getWhereTerm(), () -> this.getOrderBy(), () -> this.offset, () -> this.rowCount, () -> this.fieldsForStatement);
    final PreparedStmtHolder count = new PreparedStmtHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            FromClause from = BasicCursor.this.getFrom();
            if (BasicCursor.this.fromTerm == null) {
                BasicCursor.this.fromTerm = new FromTerm(from.getParameters());
            }
            WhereTerm where = BasicCursor.this.qmaker.getWhereTerm();
            BasicCursor.this.fromTerm.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            where.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            return BasicCursor.this.db().getSetCountStatement(BasicCursor.this.conn(), from, where.getWhere());
        }
    };
    final PreparedStmtHolder position = new OrderFieldsMaskedStatementHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            FromClause from = BasicCursor.this.getFrom();
            if (BasicCursor.this.fromTerm == null) {
                BasicCursor.this.fromTerm = new FromTerm(from.getParameters());
            }
            WhereTerm where = BasicCursor.this.qmaker.getWhereTerm('<');
            BasicCursor.this.fromTerm.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            where.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            return BasicCursor.this.db().getSetCountStatement(BasicCursor.this.conn(), BasicCursor.this.getFrom(), where.getWhere());
        }
    };
    final PreparedStmtHolder forwards = new OrderFieldsMaskedStatementHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            FromClause from = BasicCursor.this.getFrom();
            if (BasicCursor.this.fromTerm == null) {
                BasicCursor.this.fromTerm = new FromTerm(from.getParameters());
            }
            WhereTerm where = BasicCursor.this.qmaker.getWhereTerm('>');
            BasicCursor.this.fromTerm.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            where.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            return BasicCursor.this.db().getNavigationStatement(BasicCursor.this.conn(), BasicCursor.this.getFrom(), BasicCursor.this.getOrderBy(), where.getWhere(), BasicCursor.this.fieldsForStatement, BasicCursor.this.navigationOffset);
        }
    };
    final PreparedStmtHolder backwards = new OrderFieldsMaskedStatementHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            FromClause from = BasicCursor.this.getFrom();
            if (BasicCursor.this.fromTerm == null) {
                BasicCursor.this.fromTerm = new FromTerm(from.getParameters());
            }
            WhereTerm where = BasicCursor.this.qmaker.getWhereTerm('<');
            BasicCursor.this.fromTerm.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            where.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            return BasicCursor.this.db().getNavigationStatement(BasicCursor.this.conn(), BasicCursor.this.getFrom(), BasicCursor.this.getReversedOrderBy(), where.getWhere(), BasicCursor.this.fieldsForStatement, BasicCursor.this.navigationOffset);
        }
    };
    final PreparedStmtHolder here = this.getHereHolder();
    final PreparedStmtHolder first = new PreparedStmtHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            FromClause from = BasicCursor.this.getFrom();
            if (BasicCursor.this.fromTerm == null) {
                BasicCursor.this.fromTerm = new FromTerm(from.getParameters());
            }
            WhereTerm where = BasicCursor.this.qmaker.getWhereTerm();
            BasicCursor.this.fromTerm.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            where.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            return BasicCursor.this.db().getNavigationStatement(BasicCursor.this.conn(), BasicCursor.this.getFrom(), BasicCursor.this.getOrderBy(), where.getWhere(), BasicCursor.this.fieldsForStatement, 0L);
        }
    };
    final PreparedStmtHolder last = new PreparedStmtHolder(){

        protected PreparedStatement initStatement(List<ParameterSetter> program) {
            FromClause from = BasicCursor.this.getFrom();
            if (BasicCursor.this.fromTerm == null) {
                BasicCursor.this.fromTerm = new FromTerm(from.getParameters());
            }
            WhereTerm where = BasicCursor.this.qmaker.getWhereTerm();
            BasicCursor.this.fromTerm.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            where.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
            return BasicCursor.this.db().getNavigationStatement(BasicCursor.this.conn(), BasicCursor.this.getFrom(), BasicCursor.this.getReversedOrderBy(), where.getWhere(), BasicCursor.this.fieldsForStatement, 0L);
        }
    };
    private final Map<String, AbstractFilter> filters = new HashMap<String, AbstractFilter>();
    private String[] orderByNames;
    private int[] orderByIndices;
    private boolean[] descOrders;
    private long offset = 0L;
    private long navigationOffset = 0L;
    private long rowCount = 0L;
    private Expr complexFilter;
    private final WhereTermsMaker qmaker = new WhereTermsMaker(new WhereMakerParamsProvider(){

        @Override
        public void initOrderBy() {
            if (BasicCursor.this.orderByNames == null) {
                BasicCursor.this.orderBy();
            }
        }

        @Override
        public QueryBuildingHelper dba() {
            return BasicCursor.this.db();
        }

        @Override
        public String[] sortFields() {
            return BasicCursor.this.orderByNames;
        }

        @Override
        public boolean[] descOrders() {
            return BasicCursor.this.descOrders;
        }

        @Override
        public Map<String, AbstractFilter> filters() {
            return BasicCursor.this.filters;
        }

        @Override
        public Expr complexFilter() {
            return BasicCursor.this.complexFilter;
        }

        @Override
        public In inFilter() {
            return BasicCursor.this.getIn();
        }

        @Override
        public int[] sortFieldsIndices() {
            return BasicCursor.this.orderByIndices;
        }

        @Override
        public Object[] values() {
            return BasicCursor.this._currentValues();
        }

        @Override
        public boolean isNullable(String columnName) {
            return ((ColumnMeta)BasicCursor.this.meta().getColumns().get(columnName)).isNullable();
        }
    });

    public BasicCursor(CallContext context) {
        super(context);
    }

    public BasicCursor(CallContext context, Set<String> fields) {
        this(context);
        if (!this.meta().getColumns().keySet().containsAll(fields)) {
            throw new CelestaException("Not all of specified columns exist!!!");
        }
        this.fields = fields;
        this.prepareOrderBy(new ColumnMeta[0]);
        this.fillFieldsForStatement();
    }

    static BasicCursor create(DataGrainElement element, CallContext callContext) {
        try {
            return BasicCursor.getCursorClass(element).getConstructor(CallContext.class).newInstance(callContext);
        }
        catch (ReflectiveOperationException ex) {
            throw new CelestaException("Cursor creation failed for grain element: " + element.getName(), (Throwable)ex);
        }
    }

    static BasicCursor create(DataGrainElement element, CallContext callContext, Set<String> fields) {
        try {
            return BasicCursor.getCursorClass(element).getConstructor(CallContext.class, Set.class).newInstance(callContext, fields);
        }
        catch (ReflectiveOperationException ex) {
            throw new CelestaException("Cursor creation failed for grain element: " + element.getName(), (Throwable)ex);
        }
    }

    static Class<? extends BasicCursor> getCursorClass(DataGrainElement element) throws ClassNotFoundException {
        String namespace = element.getGrain().getNamespace().getValue();
        String cursorClassName = element.getName().substring(0, 1).toUpperCase() + element.getName().substring(1) + "Cursor";
        cursorClassName = (namespace.isEmpty() ? "" : namespace + ".") + cursorClassName;
        return Class.forName(cursorClassName, true, Thread.currentThread().getContextClassLoader());
    }

    PreparedStmtHolder getHereHolder() {
        return new OrderFieldsMaskedStatementHolder(){

            protected PreparedStatement initStatement(List<ParameterSetter> program) {
                WhereTerm where = BasicCursor.this.qmaker.getWhereTerm('=');
                where.programParams(program, (QueryBuildingHelper)BasicCursor.this.db());
                return BasicCursor.this.db().getNavigationStatement(BasicCursor.this.conn(), BasicCursor.this.getFrom(), "", where.getWhere(), BasicCursor.this.fieldsForStatement, 0L);
            }
        };
    }

    final void closeStatements(PreparedStmtHolder ... stmts) {
        for (PreparedStmtHolder stmt : stmts) {
            stmt.close();
        }
    }

    @Override
    protected void closeInternal() {
        super.closeInternal();
        this.closeStatements(this.set, this.forwards, this.backwards, this.here, this.first, this.last, this.count, this.position);
    }

    final Map<String, AbstractFilter> getFilters() {
        return this.filters;
    }

    public abstract DataGrainElement meta();

    public boolean canInsert() {
        if (this.isClosed()) {
            throw new CelestaException("DataAccessor is closed.");
        }
        IPermissionManager permissionManager = ((CallContext)this.callContext()).getPermissionManager();
        return permissionManager.isActionAllowed((CallContext)this.callContext(), (GrainElement)this.meta(), Action.INSERT);
    }

    public boolean canModify() {
        if (this.isClosed()) {
            throw new CelestaException("DataAccessor is closed.");
        }
        IPermissionManager permissionManager = ((CallContext)this.callContext()).getPermissionManager();
        return permissionManager.isActionAllowed((CallContext)this.callContext(), (GrainElement)this.meta(), Action.MODIFY);
    }

    public boolean canDelete() {
        if (this.isClosed()) {
            throw new CelestaException("DataAccessor is closed.");
        }
        IPermissionManager permissionManager = ((CallContext)this.callContext()).getPermissionManager();
        return permissionManager.isActionAllowed((CallContext)this.callContext(), (GrainElement)this.meta(), Action.DELETE);
    }

    private void closeStmt(PreparedStatement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new CelestaException(DATABASE_CLOSING_ERROR, new Object[]{this._objectName(), e.getMessage()});
        }
    }

    protected final void closeSet() {
        this.cursor = null;
        this.set.close();
        this.forwards.close();
        this.backwards.close();
        this.first.close();
        this.last.close();
        this.count.close();
        this.position.close();
    }

    private String getOrderBy(boolean reverse) {
        if (this.orderByNames == null) {
            this.orderBy();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.orderByNames.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.orderByNames[i]);
            if (!(reverse ^ this.descOrders[i])) continue;
            sb.append(" desc");
        }
        return sb.toString();
    }

    public final String getOrderBy() {
        return this.getOrderBy(false);
    }

    final List<String> getOrderByFields() {
        if (this.orderByNames == null) {
            this.orderBy();
        }
        return Arrays.asList(this.orderByNames);
    }

    final String getReversedOrderBy() {
        return this.getOrderBy(true);
    }

    public String[] orderByColumnNames() {
        if (this.orderByNames == null) {
            this.orderBy();
        }
        return this.orderByNames;
    }

    public boolean[] descOrders() {
        if (this.orderByNames == null) {
            this.orderBy();
        }
        return this.descOrders;
    }

    public final boolean tryFindSet() {
        boolean result;
        if (!this.canRead()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.READ);
        }
        PreparedStatement ps = this.set.getStatement(this._currentValues(), 0);
        try {
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.cursor = ps.executeQuery();
            result = this.cursor.next();
            if (result) {
                this._parseResult(this.cursor);
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    public final boolean tryFirst() {
        return this.navigate("-");
    }

    public final void first() {
        if (!this.navigate("-")) {
            this.raiseNotFound();
        }
    }

    public final boolean tryLast() {
        return this.navigate("+");
    }

    public final void last() {
        if (!this.navigate("+")) {
            this.raiseNotFound();
        }
    }

    public final boolean next() {
        return this.navigate(">");
    }

    public final boolean previous() {
        return this.navigate("<");
    }

    private void raiseNotFound() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, AbstractFilter> e : this.filters.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(String.format("%s=%s", e.getKey(), e.getValue().toString()));
        }
        throw new CelestaException("There is no %s (%s).", new Object[]{this._objectName(), sb.toString()});
    }

    public final void findSet() {
        if (!this.tryFindSet()) {
            this.raiseNotFound();
        }
    }

    public final String asCSVLine() {
        Object[] values = this._currentValues();
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (value == null) {
                sb.append("NULL");
                continue;
            }
            BasicCursor.quoteFieldForCSV(value.toString(), sb);
        }
        return sb.toString();
    }

    private static void quoteFieldForCSV(String fieldValue, StringBuilder sb) {
        char c;
        int i;
        boolean needQuotes = false;
        for (i = 0; !needQuotes && i < fieldValue.length(); ++i) {
            c = fieldValue.charAt(i);
            needQuotes = c == '\"' || c == ',';
        }
        if (needQuotes) {
            sb.append('\"');
            for (i = 0; i < fieldValue.length(); ++i) {
                c = fieldValue.charAt(i);
                sb.append(c);
                if (c != '\"') continue;
                sb.append('\"');
            }
            sb.append('\"');
        } else {
            sb.append(fieldValue);
        }
    }

    public final boolean nextInSet() {
        boolean result;
        try {
            result = this.cursor == null ? this.tryFindSet() : this.cursor.next();
            if (result) {
                this._parseResult(this.cursor);
            } else {
                this.cursor.close();
                this.cursor = null;
            }
        }
        catch (SQLException e) {
            result = false;
        }
        return result;
    }

    public boolean navigate(String command) {
        if (!this.canRead()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.READ);
        }
        Matcher m = NAVIGATION.matcher(command);
        if (!m.matches()) {
            throw new CelestaException("Invalid navigation command: '%s', should consist of '+', '-', '>', '<' and '=' only!", new Object[]{command});
        }
        if (this.navigationOffset != 0L) {
            this.closeStatements(this.backwards, this.forwards);
        }
        this.navigationOffset = 0L;
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            PreparedStatement navigator = this.chooseNavigator(c);
            if (!this.executeNavigator(navigator)) continue;
            return true;
        }
        return false;
    }

    public boolean navigate(String command, long offset) {
        if (!this.canRead()) {
            throw new PermissionDeniedException((CallContext)this.callContext(), (GrainElement)this.meta(), Action.READ);
        }
        Matcher m = NAVIGATION_WITH_OFFSET.matcher(command);
        if (!m.matches()) {
            throw new CelestaException("Invalid navigation command: '%s', should consist only one of  '>' or '<'!", new Object[]{command});
        }
        if (offset < 0L) {
            throw new CelestaException("Invalid navigation offset: offset should not be less than 0");
        }
        if (this.navigationOffset != offset) {
            this.navigationOffset = offset;
            this.closeStatements(this.backwards, this.forwards);
        }
        PreparedStatement navigator = this.chooseNavigator(command.charAt(0));
        LOGGER.trace("{}", (Object)navigator);
        return this.executeNavigator(navigator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeNavigator(PreparedStatement navigator) {
        try {
            LOGGER.trace("{}", (Object)navigator);
            try (ResultSet rs = navigator.executeQuery();){
                if (!rs.next()) return false;
                this._parseResult(rs);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new CelestaException(NAVIGATING_ERROR, new Object[]{e.getMessage()});
        }
    }

    private PreparedStatement chooseNavigator(char c) {
        Object[] rec = this._currentValues();
        switch (c) {
            case '<': {
                return this.backwards.getStatement(rec, 0);
            }
            case '>': {
                return this.forwards.getStatement(rec, 0);
            }
            case '=': {
                return this.here.getStatement(rec, 0);
            }
            case '-': {
                return this.first.getStatement(rec, 0);
            }
            case '+': {
                return this.last.getStatement(rec, 0);
            }
        }
        return null;
    }

    final WhereTermsMaker getQmaker() {
        return this.qmaker;
    }

    final ColumnMeta<?> validateColumnName(String name) {
        ColumnMeta column = (ColumnMeta)this.meta().getColumns().get(name);
        if (column == null) {
            throw new CelestaException("No column %s exists in table %s.", new Object[]{name, this._objectName()});
        }
        return column;
    }

    private Object validateColumnValue(ColumnMeta<?> column, Object value) {
        if (value == null) {
            return value;
        }
        if (!column.getJavaClass().isAssignableFrom(value.getClass())) {
            throw new CelestaException("Value %s is not of type %s.", new Object[]{value, column.getJavaClass()});
        }
        return value;
    }

    @Deprecated
    public final void setRange(String name) {
        this.setRange(this.validateColumnName(name));
    }

    public final void setRange(ColumnMeta<?> column) {
        this.validateColumnName(column.getName());
        if (this.isClosed()) {
            return;
        }
        if (this.filters.remove(column.getName()) != null) {
            this.closeSet();
        }
    }

    @Deprecated
    public final void setRange(String name, Object value) {
        ColumnMeta<?> column = this.validateColumnName(name);
        this.setRange(column, this.validateColumnValue(column, value));
    }

    public final <T> void setRange(ColumnMeta<? super T> column, T value) {
        this.validateColumnName(column.getName());
        if (value == null) {
            this.setFilter(column, "null");
        } else {
            if (this.isClosed()) {
                return;
            }
            AbstractFilter oldFilter = this.filters.get(column.getName());
            if (oldFilter instanceof SingleValue) {
                ((SingleValue)oldFilter).setValue(value);
            } else {
                this.filters.put(column.getName(), (AbstractFilter)new SingleValue(value));
                this.closeSet();
            }
        }
    }

    @Deprecated
    public final void setRange(String name, Object valueFrom, Object valueTo) {
        ColumnMeta<?> column = this.validateColumnName(name);
        this.setRange(column, this.validateColumnValue(column, valueFrom), this.validateColumnValue(column, valueTo));
    }

    public final <T> void setRange(ColumnMeta<? super T> column, T valueFrom, T valueTo) {
        this.validateColumnName(column.getName());
        if (this.isClosed()) {
            return;
        }
        AbstractFilter oldFilter = this.filters.get(column.getName());
        if (oldFilter instanceof Range) {
            ((Range)oldFilter).setValues(valueFrom, valueTo);
        } else {
            this.filters.put(column.getName(), (AbstractFilter)new Range(valueFrom, valueTo));
            this.closeSet();
        }
    }

    @Deprecated
    public final void setFilter(String name, String value) {
        this.setFilter(this.validateColumnName(name), value);
    }

    public final void setFilter(ColumnMeta<?> column, String value) {
        this.validateColumnName(column.getName());
        if (value == null || value.isEmpty()) {
            throw new CelestaException("Filter for column %s is null or empty. Use setRange(column) to remove any filters from the column.", new Object[]{column.getName()});
        }
        AbstractFilter oldFilter = this.filters.put(column.getName(), new Filter(value, column));
        if (this.isClosed()) {
            return;
        }
        if (!(oldFilter instanceof Filter) || !value.equals(oldFilter.toString())) {
            this.closeSet();
        }
    }

    public final void setComplexFilter(String condition) {
        Expr buf = CelestaParser.parseComplexFilter((String)condition, (IdentifierParser)this.meta().getGrain().getScore().getIdentifierParser());
        try {
            buf.resolveFieldRefs((GrainElement)this.meta());
        }
        catch (ParseException e) {
            throw new CelestaException(e.getMessage());
        }
        this.complexFilter = buf;
        if (this.isClosed()) {
            return;
        }
        this.closeSet();
    }

    public final String getComplexFilter() {
        return this.complexFilter == null ? null : this.complexFilter.getCSQL();
    }

    public final void limit(long offset, long rowCount) {
        if (offset < 0L) {
            throw new CelestaException("Negative offset (%d) in limit(...) call", new Object[]{offset});
        }
        if (rowCount < 0L) {
            throw new CelestaException("Negative rowCount (%d) in limit(...) call", new Object[]{rowCount});
        }
        this.offset = offset;
        this.rowCount = rowCount;
        this.closeSet();
    }

    public final void reset() {
        this.filters.clear();
        this.resetSpecificState();
        this.complexFilter = null;
        this.orderByNames = null;
        this.orderByIndices = null;
        this.descOrders = null;
        this.offset = 0L;
        this.rowCount = 0L;
        this.closeSet();
    }

    protected void resetSpecificState() {
    }

    @Deprecated
    public final void orderBy(String ... names) {
        ColumnMeta[] columns = new ColumnMeta[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Matcher m = COLUMN_NAME.matcher(name);
            if (!m.matches()) {
                throw new CelestaException("orderby() argument '%s' should match pattern <column name> [ASC|DESC]", new Object[]{name});
            }
            String colName = m.group(1);
            String colOrdering = Optional.ofNullable(m.group(2)).map(String::trim).orElse(null);
            ColumnMeta column = this.validateColumnName(colName);
            if ("asc".equalsIgnoreCase(colOrdering)) {
                column = column.asc();
            } else if ("desc".equalsIgnoreCase(colOrdering)) {
                column = column.desc();
            }
            columns[i] = column;
        }
        this.orderBy(columns);
    }

    public final void orderBy(ColumnMeta<?> ... columns) {
        this.prepareOrderBy(columns);
        if (!this.fieldsForStatement.isEmpty()) {
            this.fillFieldsForStatement();
        }
        this.closeSet();
    }

    public final void orderBy() {
        this.orderBy(new ColumnMeta[0]);
    }

    private void prepareOrderBy(ColumnMeta<?> ... columns) {
        ArrayList<String> l = new ArrayList<String>(8);
        ArrayList<Boolean> ol = new ArrayList<Boolean>(8);
        HashSet<String> colNames = new HashSet<String>();
        for (ColumnMeta<?> column : columns) {
            String colName = column.getName();
            this.validateColumnName(colName);
            if (!colNames.add(colName)) {
                throw new CelestaException("Column '%s' is used more than once in orderby() call", new Object[]{colName});
            }
            l.add(String.format("\"%s\"", colName));
            ColumnMeta.Ordering ordering = column.ordering();
            ol.add(ordering != null && ordering != ColumnMeta.Ordering.ASC);
        }
        this.appendPK(l, ol, colNames);
        this.orderByNames = new String[l.size()];
        this.orderByIndices = new int[l.size()];
        this.descOrders = new boolean[l.size()];
        for (int i = 0; i < this.orderByNames.length; ++i) {
            this.orderByNames[i] = l.get(i);
            this.descOrders[i] = ol.get(i);
            this.orderByIndices[i] = this.meta().getColumnIndex(WhereTermsMaker.unquot(this.orderByNames[i]));
        }
    }

    abstract void appendPK(List<String> var1, List<Boolean> var2, Set<String> var3);

    public void clear() {
        this._clearBuffer(true);
        this.filters.clear();
        this.clearSpecificState();
        this.complexFilter = null;
        if (!this.fieldsForStatement.isEmpty()) {
            this.prepareOrderBy(new ColumnMeta[0]);
            this.fillFieldsForStatement();
        }
        this.orderByNames = null;
        this.orderByIndices = null;
        this.descOrders = null;
        this.offset = 0L;
        this.rowCount = 0L;
        this.closeSet();
    }

    public final int count() {
        PreparedStatement stmt = this.count.getStatement(this._currentValues(), 0);
        int result = this.count(stmt);
        this.count.close();
        return result;
    }

    public final int position() {
        PreparedStatement stmt = this.position.getStatement(this._currentValues(), 0);
        LOGGER.trace("{}", (Object)stmt);
        return this.count(stmt);
    }

    private int count(PreparedStatement stmt) {
        int result;
        try (ResultSet rs = stmt.executeQuery();){
            rs.next();
            result = rs.getInt(1);
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        finally {
            this.closeStmt(stmt);
        }
        return result;
    }

    public final void copyFiltersFrom(BasicCursor c) {
        if (!c._grainName().equals(this._grainName()) || !c._objectName().equals(this._objectName())) {
            throw new CelestaException("Cannot assign filters from cursor for %s.%s to cursor for %s.%s.", new Object[]{c._grainName(), c._objectName(), this._grainName(), this._objectName()});
        }
        this.filters.clear();
        this.filters.putAll(c.filters);
        this.complexFilter = c.complexFilter;
        this.copySpecificFiltersFrom(c);
        this.offset = c.offset;
        this.rowCount = c.rowCount;
        this.closeSet();
    }

    protected void copySpecificFiltersFrom(BasicCursor c) {
    }

    public final void copyOrderFrom(BasicCursor c) {
        if (!c._grainName().equals(this._grainName()) || !c._objectName().equals(this._objectName())) {
            throw new CelestaException("Cannot assign ordering from cursor for %s.%s to cursor for %s.%s.", new Object[]{c._grainName(), c._objectName(), this._grainName(), this._objectName()});
        }
        this.orderByNames = c.orderByNames;
        this.orderByIndices = c.orderByIndices;
        this.descOrders = c.descOrders;
        this.closeSet();
    }

    public boolean isEquivalent(BasicCursor c) {
        if (this.filters.size() != c.filters.size()) {
            return false;
        }
        for (Map.Entry<String, AbstractFilter> e : this.filters.entrySet()) {
            if (e.getValue().filterEquals(c.filters.get(e.getKey()))) continue;
            return false;
        }
        if (this.complexFilter != null && c.complexFilter != null ? !this.complexFilter.getCSQL().equals(c.complexFilter.getCSQL()) : this.complexFilter != c.complexFilter) {
            return false;
        }
        if (!this.isEquivalentSpecific(c)) {
            return false;
        }
        if (this.orderByNames == null) {
            this.orderBy();
        }
        if (c.orderByNames == null) {
            c.orderBy();
        }
        if (!Arrays.equals(this.orderByNames, c.orderByNames)) {
            return false;
        }
        return Arrays.equals(this.descOrders, c.descOrders);
    }

    boolean isEquivalentSpecific(BasicCursor c) {
        return true;
    }

    public final void setValue(String name, Object value) {
        this.validateColumnName(name);
        this._setFieldValue(name, value);
    }

    public final Object getValue(String name) {
        this.validateColumnName(name);
        return this._getFieldValue(name);
    }

    protected final boolean inRec(String field) {
        return this.fieldsForStatement.isEmpty() || this.fieldsForStatement.contains(field);
    }

    protected In getIn() {
        return null;
    }

    protected FromClause getFrom() {
        FromClause result = new FromClause();
        DataGrainElement ge = this.meta();
        result.setGe(ge);
        result.setExpression(this.db().tableString(ge.getGrain().getName(), ge.getName()));
        return result;
    }

    private void fillFieldsForStatement() {
        this.fieldsForStatement.clear();
        this.fieldsForStatement = Arrays.stream(this.orderByColumnNames()).map(f -> f.replaceAll("\"", "")).collect(Collectors.toSet());
        this.fieldsForStatement.addAll(this.fields);
    }

    public abstract void copyFieldsFrom(BasicCursor var1);

    public final Object[] getCurrentValues() {
        return this._currentValues();
    }

    public final void clearBuffer(boolean withKeys) {
        this._clearBuffer(withKeys);
    }

    public final BasicCursor getBufferCopy(CallContext context, List<String> fetchedFields) {
        return this._getBufferCopy(context, fetchedFields);
    }

    protected abstract BasicCursor _getBufferCopy(CallContext var1, List<String> var2);

    protected abstract Object[] _currentValues();

    protected abstract void _clearBuffer(boolean var1);

    protected abstract void _setFieldValue(String var1, Object var2);

    protected abstract Object _getFieldValue(String var1);

    protected abstract void _parseResult(ResultSet var1) throws SQLException;

    abstract class OrderFieldsMaskedStatementHolder
    extends MaskedStatementHolder {
        OrderFieldsMaskedStatementHolder() {
        }

        protected final int[] getNullsMaskIndices() {
            if (BasicCursor.this.orderByNames == null) {
                BasicCursor.this.orderBy();
            }
            return BasicCursor.this.orderByIndices;
        }
    }
}

