/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.filter;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.filter.FilterParserConstants;
import ru.curs.celesta.dbutils.filter.FilterParserTokenManager;
import ru.curs.celesta.dbutils.filter.ParseException;
import ru.curs.celesta.dbutils.filter.SimpleCharStream;
import ru.curs.celesta.dbutils.filter.Token;
import ru.curs.celesta.dbutils.filter.TokenMgrError;

public class FilterParser
implements FilterParserConstants {
    private static final String INVALID_QUOTED_FORMAT = "Invalid quoted string format.";
    private FilterType filterType;
    private String fieldName;
    private SQLTranslator tr;
    public FilterParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[21];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    FilterParser(StringReader sr, SQLTranslator tr) {
        this(sr);
        this.tr = tr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String translateFilter(FilterType fieldType, String fieldName, String filter, SQLTranslator tr) {
        try (StringReader sr = new StringReader(filter);){
            FilterParser parser = new FilterParser(sr, tr);
            String string = parser.filterExpr(fieldType, fieldName);
            return string;
        }
        catch (ParseException | TokenMgrError e) {
            CelestaException ce = new CelestaException("Invalid field filter '%s': %s", new Object[]{filter, e.getMessage()});
            ce.initCause(e);
            throw ce;
        }
    }

    private String translateDate(String dateLiteral) throws ParseException {
        try {
            return this.tr.translateDate(dateLiteral);
        }
        catch (CelestaException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static String quoteString(String lexvalue) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        for (int i = 0; i < lexvalue.length(); ++i) {
            char c = lexvalue.charAt(i);
            sb.append(c);
            if (c != '\'') continue;
            sb.append('\'');
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String unquoteString(String lexvalue) throws ParseException {
        StringBuilder sb = new StringBuilder();
        int state = 0;
        block5: for (int i = 0; i < lexvalue.length(); ++i) {
            char c = lexvalue.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block5;
                    }
                    throw new ParseException(INVALID_QUOTED_FORMAT);
                }
                case 1: {
                    if (c == '\'') {
                        state = 2;
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == '\'') {
                        sb.append('\'');
                        state = 1;
                        continue block5;
                    }
                    throw new ParseException(INVALID_QUOTED_FORMAT);
                }
            }
        }
        return sb.toString();
    }

    public final String filterExpr(FilterType filterType, String fieldName) throws ParseException {
        String result;
        this.filterType = filterType;
        this.fieldName = fieldName;
        if (filterType == FilterType.OTHER) {
            result = this.nullExpr();
            this.jj_consume_token(0);
        } else if (filterType != FilterType.OTHER) {
            result = this.expr();
            this.jj_consume_token(0);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final String nullExpr() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                if ("" == null) break;
                return String.format("%s is null", this.fieldName);
            }
            case 7: {
                this.jj_consume_token(7);
                this.jj_consume_token(6);
                if ("" == null) break;
                return String.format("not (%s is null)", this.fieldName);
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String expr() throws ParseException {
        StringBuilder result = new StringBuilder();
        String buf = this.singleExpr();
        result.append(buf);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: {
                        block13: while (true) {
                            this.jj_consume_token(8);
                            buf = this.singleExpr();
                            result.append(" and " + buf);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 8: {
                                    continue block13;
                                }
                            }
                            break;
                        }
                        this.jj_la1[1] = this.jj_gen;
                        break block0;
                    }
                    case 9: {
                        block14: while (true) {
                            this.jj_consume_token(9);
                            buf = this.singleExpr();
                            result.append(" or " + buf);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 9: {
                                    continue block14;
                                }
                            }
                            break;
                        }
                        this.jj_la1[2] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if ("" != null) {
            return result.toString();
        }
        throw new Error("Missing return statement in function");
    }

    public final String singleExpr() throws ParseException {
        String result;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                String buf = this.expr();
                this.jj_consume_token(11);
                result = "(" + buf + ")";
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                String buf = this.singleExpr();
                result = "not (" + buf + ")";
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                if (this.jj_2_1(1)) {
                    String buf;
                    result = buf = this.term();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final String term() throws ParseException {
        String result;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                Token tok = this.jj_consume_token(6);
                result = String.format("%s is null", this.fieldName);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                if (this.filterType == FilterType.NUMERIC) {
                    result = this.numTerm();
                    break;
                }
                if (this.filterType == FilterType.DATETIME) {
                    result = this.dateTerm();
                    break;
                }
                if (this.filterType == FilterType.TEXT) {
                    result = this.textTerm();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final String numTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                String val1 = this.number();
                if ("" == null) break;
                return String.format("%s > %s", this.fieldName, val1);
            }
            case 13: {
                this.jj_consume_token(13);
                String val1 = this.number();
                if ("" == null) break;
                return String.format("%s < %s", this.fieldName, val1);
            }
            case 14: {
                this.jj_consume_token(14);
                String val1 = this.number();
                if ("" == null) break;
                return String.format("%s <= %s", this.fieldName, val1);
            }
            case 2: 
            case 3: {
                String val1 = this.number();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 2: 
                            case 3: {
                                String val2 = this.number();
                                if ("" == null) break;
                                return String.format("%s between %s and %s", this.fieldName, val1, val2);
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                            }
                        }
                        if ("" == null) break;
                        return String.format("%s >= %s", this.fieldName, val1);
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                if ("" == null) break;
                return String.format("%s = %s", this.fieldName, val1);
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String number() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 3: {
                Token tok = this.jj_consume_token(3);
                if ("" == null) break;
                return tok.toString();
            }
            case 2: {
                Token tok = this.jj_consume_token(2);
                if ("" == null) break;
                return tok.toString();
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String dateTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                String val1 = this.date();
                if ("" == null) break;
                return String.format("%s > %s", this.fieldName, val1);
            }
            case 13: {
                this.jj_consume_token(13);
                String val1 = this.date();
                if ("" == null) break;
                return String.format("%s < %s", this.fieldName, val1);
            }
            case 14: {
                this.jj_consume_token(14);
                String val1 = this.date();
                if ("" == null) break;
                return String.format("%s <= %s", this.fieldName, val1);
            }
            case 5: {
                String val1 = this.date();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                String val2 = this.date();
                                if ("" == null) break;
                                return String.format("%s between %s and %s", this.fieldName, val1, val2);
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                            }
                        }
                        if ("" == null) break;
                        return String.format("%s >= %s", this.fieldName, val1);
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                if ("" == null) break;
                return String.format("%s = %s", this.fieldName, val1);
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String date() throws ParseException {
        Token tok = this.jj_consume_token(5);
        if ("" != null) {
            return this.translateDate(tok.toString());
        }
        throw new Error("Missing return statement in function");
    }

    public final String textTerm() throws ParseException {
        boolean ci = false;
        String fn = this.fieldName;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                ci = true;
                fn = "UPPER(" + fn + ")";
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                String val1 = this.text(ci);
                if ("" == null) break;
                return String.format("%s > %s", fn, val1);
            }
            case 13: {
                this.jj_consume_token(13);
                String val1 = this.text(ci);
                if ("" == null) break;
                return String.format("%s < %s", fn, val1);
            }
            case 14: {
                this.jj_consume_token(14);
                String val1 = this.text(ci);
                if ("" == null) break;
                return String.format("%s <= %s", fn, val1);
            }
            case 16: {
                String val1 = this.likeFilter(ci);
                if ("" == null) break;
                return String.format("%s like %s", fn, FilterParser.quoteString(val1));
            }
            case 5: {
                String val1 = this.text(ci);
                block10 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: 
                    case 16: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 14: {
                                this.jj_consume_token(14);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 5: {
                                        String val2 = this.text(ci);
                                        if ("" == null) break;
                                        return String.format("%s between %s and %s", fn, val1, val2);
                                    }
                                    default: {
                                        this.jj_la1[15] = this.jj_gen;
                                    }
                                }
                                if ("" == null) break block10;
                                return String.format("%s >= %s", fn, val1);
                            }
                            case 16: {
                                String val2 = this.likeFilter(ci);
                                if ("" == null) break block10;
                                return String.format("%s like %s", fn, FilterParser.quoteString(FilterParser.unquoteString(val1) + val2));
                            }
                            default: {
                                this.jj_la1[16] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                if ("" == null) break;
                return String.format("%s = %s", fn, val1);
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String likeFilter(boolean ci) throws ParseException {
        StringBuilder sb = new StringBuilder();
        this.jj_consume_token(16);
        sb.append('%');
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                String val = this.text(ci);
                sb.append(FilterParser.unquoteString(val));
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        val = this.likeFilter(ci);
                        sb.append(val);
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        if ("" != null) {
            return sb.toString();
        }
        throw new Error("Missing return statement in function");
    }

    public final String text(boolean ci) throws ParseException {
        Token tok = this.jj_consume_token(5);
        if ("" != null) {
            return ci ? tok.toString().toUpperCase() : tok.toString();
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_term_181_5_7() {
        return this.jj_3R_textTerm_214_4_10();
    }

    private boolean jj_3R_term_180_5_6() {
        return this.jj_3R_dateTerm_201_6_9();
    }

    private boolean jj_3R_term_179_5_5() {
        return this.jj_3R_numTerm_187_6_8();
    }

    private boolean jj_3R_term_178_3_4() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_term_177_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_term_178_3_4()) {
            this.jj_scanpos = xsp;
            this.jj_lookingAhead = true;
            this.jj_semLA = this.filterType == FilterType.NUMERIC;
            this.jj_lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_term_179_5_5()) {
                this.jj_scanpos = xsp;
                this.jj_lookingAhead = true;
                this.jj_semLA = this.filterType == FilterType.DATETIME;
                this.jj_lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_term_180_5_6()) {
                    this.jj_scanpos = xsp;
                    this.jj_lookingAhead = true;
                    this.jj_semLA = this.filterType == FilterType.TEXT;
                    this.jj_lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_term_181_5_7()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_textTerm_220_6_24() {
        return this.jj_3R_text_242_6_28();
    }

    private boolean jj_3R_textTerm_219_6_23() {
        return this.jj_3R_likeFilter_234_5_27();
    }

    private boolean jj_3R_textTerm_218_6_22() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_textTerm_217_6_21() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3R_textTerm_216_6_20() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_textTerm_214_5_19() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_1() {
        return this.jj_3R_term_177_3_3();
    }

    private boolean jj_3R_textTerm_214_4_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_textTerm_214_5_19()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_textTerm_216_6_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_textTerm_217_6_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_textTerm_218_6_22()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_textTerm_219_6_23()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_textTerm_220_6_24()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_date_209_6_26() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_dateTerm_204_6_18() {
        return this.jj_3R_date_209_6_26();
    }

    private boolean jj_3R_dateTerm_203_6_17() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_dateTerm_202_6_16() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3R_dateTerm_201_6_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_dateTerm_201_6_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_dateTerm_202_6_16()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_dateTerm_203_6_17()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_dateTerm_204_6_18()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_dateTerm_201_6_15() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_number_196_6_30() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_number_195_6_29() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_text_242_6_28() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_number_195_6_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_number_195_6_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_number_196_6_30()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_numTerm_190_6_14() {
        return this.jj_3R_number_195_6_25();
    }

    private boolean jj_3R_numTerm_189_6_13() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_numTerm_188_6_12() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3R_numTerm_187_6_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_numTerm_187_6_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_numTerm_188_6_12()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_numTerm_189_6_13()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_numTerm_190_6_14()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_numTerm_187_6_11() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_likeFilter_234_5_27() {
        return this.jj_scan_token(16);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{192, 256, 512, 768, 768, 1152, 64, 12, 16384, 28684, 12, 32, 16384, 28704, 32768, 32, 81920, 81920, 94240, 65536, 32};
    }

    public FilterParser(InputStream stream) {
        this(stream, null);
    }

    public FilterParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new FilterParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FilterParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FilterParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new FilterParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FilterParser(FilterParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(FilterParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[17];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 21; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 17; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        FilterParser.jj_la1_init_0();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static interface SQLTranslator {
        public String translateDate(String var1);
    }

    public static enum FilterType {
        NUMERIC,
        TEXT,
        DATETIME,
        OTHER;

    }
}

