/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.event.TriggerType;

public final class TriggerDispatcher {
    private final EnumMap<TriggerType, Map<Class<? extends Cursor>, List<Consumer<?>>>> triggerMap = new EnumMap(TriggerType.class);

    public TriggerDispatcher() {
        Arrays.stream(TriggerType.values()).forEach(t -> {
            Map cfr_ignored_0 = this.triggerMap.put((TriggerType)t, new HashMap());
        });
    }

    public <T extends Cursor> void registerTrigger(TriggerType type, Class<T> cursorClass, Consumer<? super T> consumer) {
        Map<Class<Cursor>, List<Consumer<?>>> cursorClassMap = this.triggerMap.get(type);
        cursorClassMap.computeIfAbsent(cursorClass, s -> new ArrayList()).add(consumer);
    }

    public void fireTrigger(TriggerType type, Cursor cursor) {
        Map<Class<Cursor>, List<Consumer<?>>> cursorClassMap = this.triggerMap.get(type);
        Class<?> cursorClass = cursor.getClass();
        List<Consumer> triggers = cursorClassMap.getOrDefault(cursorClass, Collections.emptyList());
        triggers.forEach(consumer -> consumer.accept(cursor));
    }
}

