/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.plugin.CursorGenerator;
import ru.curs.celesta.plugin.ScoreProperties;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.View;
import ru.curs.celesta.score.discovery.DefaultScoreDiscovery;
import ru.curs.celesta.score.discovery.ScoreDiscovery;

@Mojo(name="gen-cursors", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenCursorsMojo
extends AbstractMojo {
    private static final Map<String, String> lifeCyclePhaseToGeneratedSourcesDirName;
    private static final Map<String, Function<MavenProject, Consumer<String>>> lifeCyclePhaseToAddCompileSourceRootConsumer;
    @Parameter(property="scores", required=true)
    protected List<ScoreProperties> scores;
    @Parameter(property="genSysCursors")
    protected boolean genSysCursors;
    @Component
    private MavenProject project;
    @Component
    MojoExecution execution;

    public void execute() {
        System.out.println("celesta project is " + this.project);
        this.scores.forEach(this::processScore);
        this.addSourceRoot(this.getSourceRoot());
    }

    private void processScore(ScoreProperties properties) {
        Score score = this.initScore(properties.getPath());
        score.getGrains().values().stream().filter(g -> this.genSysCursors || !g.getScore().getSysSchemaName().equals(g.getName())).forEach(g -> this.generateCursors((Grain)g, score));
    }

    private Score initScore(String scorePath) {
        try {
            Score score = (Score)new AbstractScore.ScoreBuilder(Score.class).path(scorePath).scoreDiscovery((ScoreDiscovery)new DefaultScoreDiscovery()).build();
            return score;
        }
        catch (CelestaException | ParseException e) {
            throw new CelestaException("Can't init score", e);
        }
    }

    private void generateCursors(Grain g, Score score) {
        boolean isSysSchema = g.getName().equals(g.getScore().getSysSchemaName());
        HashMap partsToElements = new HashMap();
        ArrayList elements = new ArrayList();
        elements.addAll(g.getElements(SequenceElement.class).values());
        elements.addAll(g.getElements(Table.class).values());
        elements.addAll(g.getElements(View.class).values());
        elements.addAll(g.getElements(MaterializedView.class).values());
        elements.addAll(g.getElements(ParameterizedView.class).values());
        elements.forEach(ge -> partsToElements.computeIfAbsent(ge.getGrainPart(), gp -> new ArrayList()).add(ge));
        partsToElements.entrySet().stream().forEach(e -> {
            String scorePath;
            if (isSysSchema) {
                scorePath = "";
            } else {
                String grainPartPath = ((GrainPart)e.getKey()).getSourceFile().getAbsolutePath();
                String scoreRelativeOrAbsolutePath = Arrays.stream(score.getPath().split(File.pathSeparator)).filter(path -> grainPartPath.contains(new File((String)path).getAbsolutePath())).findFirst().get();
                File scoreDir = new File(scoreRelativeOrAbsolutePath);
                scorePath = scoreDir.getAbsolutePath();
            }
            ((List)e.getValue()).forEach(ge -> CursorGenerator.generateCursor(ge, this.getSourceRoot(), scorePath));
        });
    }

    private File getSourceRoot() {
        return new File(this.project.getBuild().getDirectory() + File.separator + lifeCyclePhaseToGeneratedSourcesDirName.get(this.execution.getLifecyclePhase()) + File.separator + "celesta");
    }

    private void addSourceRoot(File directory) {
        if (this.project != null) {
            this.getLog().info((CharSequence)("Adding compile source root for cursors: " + directory));
            lifeCyclePhaseToAddCompileSourceRootConsumer.get(this.execution.getLifecyclePhase()).apply(this.project).accept(directory.getAbsolutePath());
        }
    }

    static {
        HashMap<String, String> dirNameMap = new HashMap<String, String>();
        dirNameMap.put(null, "generated-sources");
        dirNameMap.put(LifecyclePhase.GENERATE_SOURCES.id(), "generated-sources");
        dirNameMap.put(LifecyclePhase.GENERATE_TEST_SOURCES.id(), "generated-test-sources");
        lifeCyclePhaseToGeneratedSourcesDirName = Collections.unmodifiableMap(dirNameMap);
        HashMap<String, Function<MavenProject, Consumer>> consumerMap = new HashMap<String, Function<MavenProject, Consumer>>();
        consumerMap.put(null, project -> arg_0 -> ((MavenProject)project).addCompileSourceRoot(arg_0));
        consumerMap.put(LifecyclePhase.GENERATE_SOURCES.id(), project -> arg_0 -> ((MavenProject)project).addCompileSourceRoot(arg_0));
        consumerMap.put(LifecyclePhase.GENERATE_TEST_SOURCES.id(), project -> arg_0 -> ((MavenProject)project).addTestCompileSourceRoot(arg_0));
        lifeCyclePhaseToAddCompileSourceRootConsumer = Collections.unmodifiableMap(consumerMap);
    }
}

