/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.plugin.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ru.curs.celesta.plugin.maven.AbstractCelestaMojo;
import ru.curs.celesta.plugin.maven.CursorGenerator;
import ru.curs.celesta.plugin.maven.ScoreProperties;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ReadOnlyTable;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.View;
import ru.curs.celesta.score.io.FileResource;
import ru.curs.celesta.score.io.Resource;

abstract class AbstractGenCursorsMojo
extends AbstractCelestaMojo {
    Supplier<Collection<ScoreProperties>> getScorePaths;
    String generatedSourcesDirName;
    Consumer<String> addCompileSourceRoot;

    AbstractGenCursorsMojo() {
    }

    public void execute() {
        this.getLog().info((CharSequence)("celesta project is " + this.project));
        this.getScorePaths.get().forEach(this::processScore);
        this.addSourceRoot(this.getSourceRoot());
    }

    private void processScore(ScoreProperties properties) {
        String scorePath = properties.getPath();
        Score score = this.initScore(scorePath);
        score.getGrains().values().stream().filter(this::isAllowGrain).forEach(g -> this.generateCursors((Grain)g, scorePath));
    }

    private void generateCursors(Grain g, String scorePath) {
        boolean isSysSchema = g.getName().equals(g.getScore().getSysSchemaName());
        HashMap partsToElements = new HashMap();
        ArrayList elements = new ArrayList();
        elements.addAll(g.getElements(SequenceElement.class).values());
        elements.addAll(g.getElements(Table.class).values());
        elements.addAll(g.getElements(ReadOnlyTable.class).values());
        elements.addAll(g.getElements(View.class).values());
        elements.addAll(g.getElements(MaterializedView.class).values());
        elements.addAll(g.getElements(ParameterizedView.class).values());
        elements.forEach(ge -> partsToElements.computeIfAbsent(ge.getGrainPart(), gp -> new ArrayList()).add(ge));
        partsToElements.entrySet().stream().forEach(e -> {
            String sp;
            if (isSysSchema) {
                sp = "";
            } else {
                Resource grainPartSource = ((GrainPart)e.getKey()).getSource();
                String scoreRelativeOrAbsolutePath = Arrays.stream(scorePath.split(File.pathSeparator)).filter(path -> new FileResource(new File((String)path)).contains(grainPartSource)).findFirst().get();
                File scoreDir = new File(scoreRelativeOrAbsolutePath);
                sp = scoreDir.getAbsolutePath();
            }
            ((List)e.getValue()).forEach(ge -> CursorGenerator.generateCursor(ge, this.getSourceRoot(), sp));
        });
    }

    private File getSourceRoot() {
        return new File(this.project.getBuild().getDirectory() + File.separator + this.generatedSourcesDirName + File.separator + "celesta");
    }

    private void addSourceRoot(File directory) {
        if (this.project != null) {
            this.getLog().info((CharSequence)("Adding compile source root for cursors: " + directory));
            this.addCompileSourceRoot.accept(directory.getAbsolutePath());
        }
    }
}

