/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.FireBirdColumnDefiner;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;

class FireBirdBooleanColumnDefiner
extends FireBirdColumnDefiner {
    FireBirdBooleanColumnDefiner() {
    }

    @Override
    public String getInternalDefinition(Column c) {
        return FireBirdBooleanColumnDefiner.join(c.getQuotedName(), this.dbFieldType());
    }

    @Override
    public String dbFieldType() {
        return "SMALLINT";
    }

    public String getDefaultDefinition(Column c) {
        BooleanColumn ic = (BooleanColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = "default " + (ic.getDefaultValue() != false ? "1" : "0");
        }
        return defaultStr;
    }

    @Override
    public String getFullDefinition(Column c) {
        String check = String.format("check (%s in (0, 1))", c.getQuotedName());
        return FireBirdBooleanColumnDefiner.join(this.getInternalDefinition(c), this.getDefaultDefinition(c), this.nullable(c), check);
    }
}

