/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.MsSqlColumnDefiner;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.Column;

class MsSqlBinaryColumnDefiner
extends MsSqlColumnDefiner {
    MsSqlBinaryColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "varbinary(max)";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        return MsSqlBinaryColumnDefiner.join(c.getQuotedName(), this.dbFieldType(), this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        BinaryColumn ic = (BinaryColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = this.msSQLDefault(c) + ic.getDefaultValue();
        }
        return defaultStr;
    }

    @Override
    public String getLightDefaultDefinition(Column<?> c) {
        BinaryColumn ic = (BinaryColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = "default " + ic.getDefaultValue();
        }
        return defaultStr;
    }
}

