/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.configuration;

import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.FirebirdAdaptor;
import ru.curs.celesta.dbutils.adaptors.H2Adaptor;
import ru.curs.celesta.dbutils.adaptors.MSSQLAdaptor;
import ru.curs.celesta.dbutils.adaptors.OraAdaptor;
import ru.curs.celesta.dbutils.adaptors.PostgresAdaptor;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;

public final class DbAdaptorFactory {
    private DBType dbType;
    private ConnectionPool connectionPool;
    private DdlConsumer ddlConsumer;
    private boolean h2ReferentialIntegrity;

    public DbAdaptorFactory setDbType(DBType dbType) {
        this.dbType = dbType;
        return this;
    }

    public DbAdaptorFactory setDdlConsumer(DdlConsumer ddlConsumer) {
        this.ddlConsumer = ddlConsumer;
        return this;
    }

    public DbAdaptorFactory setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    public DbAdaptorFactory setH2ReferentialIntegrity(boolean h2ReferentialIntegrity) {
        this.h2ReferentialIntegrity = h2ReferentialIntegrity;
        return this;
    }

    public DBAdaptor createDbAdaptor() {
        if (DBType.H2.equals((Object)this.dbType)) {
            return new H2Adaptor(this.connectionPool, this.ddlConsumer, this.h2ReferentialIntegrity);
        }
        if (DBType.POSTGRESQL.equals((Object)this.dbType)) {
            return new PostgresAdaptor(this.connectionPool, this.ddlConsumer);
        }
        if (DBType.MSSQL.equals((Object)this.dbType)) {
            return new MSSQLAdaptor(this.connectionPool, this.ddlConsumer);
        }
        if (DBType.ORACLE.equals((Object)this.dbType)) {
            return new OraAdaptor(this.connectionPool, this.ddlConsumer);
        }
        if (DBType.FIREBIRD.equals((Object)this.dbType)) {
            return new FirebirdAdaptor(this.connectionPool, this.ddlConsumer);
        }
        return null;
    }
}

