/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.h2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.Trigger;

public class RecVersionCheckTrigger
implements Trigger {
    int indexOfRecVersionColumn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Connection connection, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        block4: {
            String sql = "SELECT ordinal_position - 1 FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = 'recversion'";
            sql = String.format(sql, schemaName, tableName);
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery(sql);
                if (resultSet.next()) {
                    this.indexOfRecVersionColumn = resultSet.getInt(1);
                    break block4;
                }
                throw new SQLException(String.format("Can't find recversion column for %s.%s", schemaName, tableName));
            }
        }
    }

    public void fire(Connection connection, Object[] oldRow, Object[] newRow) throws SQLException {
        Integer oldRecVersion = (Integer)oldRow[this.indexOfRecVersionColumn];
        Integer newRecVersion = (Integer)newRow[this.indexOfRecVersionColumn];
        if (!oldRecVersion.equals(newRecVersion)) {
            throw new SQLException("record version check failure");
        }
        newRecVersion = newRecVersion + 1;
        newRow[this.indexOfRecVersionColumn] = newRecVersion;
    }

    public void close() throws SQLException {
    }

    public void remove() throws SQLException {
    }
}

