/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.stmt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.MaskedStatementHolder;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.dbutils.stmt.PreparedStmtHolder;
import ru.curs.celesta.dbutils.term.CsqlWhereTermsMaker;
import ru.curs.celesta.dbutils.term.FromTerm;
import ru.curs.celesta.dbutils.term.WhereTerm;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.TableElement;

public class PreparedStatementHolderFactory {
    public static MaskedStatementHolder createInsertHolder(final BasicTable meta, final DBAdaptor dbAdaptor, final Connection conn) {
        return new MaskedStatementHolder(){

            @Override
            protected int[] getNullsMaskIndices() {
                int[] result = new int[meta.getColumns().size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i;
                }
                return result;
            }

            @Override
            protected PreparedStatement initStatement(List<ParameterSetter> program) {
                return dbAdaptor.getInsertRecordStatement(conn, meta, this.getNullsMask(), program);
            }
        };
    }

    public static PreparedStmtHolder createGetHolder(final TableElement meta, final DBAdaptor dbAdaptor, final Connection conn) {
        return new PreparedStmtHolder(){

            @Override
            protected PreparedStatement initStatement(List<ParameterSetter> program) {
                WhereTerm where = CsqlWhereTermsMaker.getPKWhereTermForGet(meta);
                where.programParams(program, dbAdaptor);
                return dbAdaptor.getOneRecordStatement(conn, meta, where.getWhere(), Collections.emptySet());
            }
        };
    }

    public static PreparedStmtHolder createUpdateHolder(final BasicTable meta, final DBAdaptor dbAdaptor, final Connection conn, final Supplier<boolean[]> updateMaskSupplier, final Supplier<boolean[]> nullUpdateMaskSupplier) {
        return new PreparedStmtHolder(){

            @Override
            protected PreparedStatement initStatement(List<ParameterSetter> program) {
                WhereTerm where = CsqlWhereTermsMaker.getPKWhereTerm(meta);
                PreparedStatement result = dbAdaptor.getUpdateRecordStatement(conn, meta, (boolean[])updateMaskSupplier.get(), (boolean[])nullUpdateMaskSupplier.get(), program, where.getWhere());
                where.programParams(program, dbAdaptor);
                return result;
            }
        };
    }

    public static PreparedStmtHolder createFindSetHolder(final DBAdaptor dbAdaptor, final Connection conn, final Supplier<FromClause> fromClauseSupplier, final Supplier<FromTerm> fromTermSupplier, final Supplier<WhereTerm> whereTermSupplier, final Supplier<String> orderBySupplier, final Supplier<Long> offsetSupplier, final Supplier<Long> rowCountSupplier, final Supplier<Set<String>> fieldsForStatementSupplier) {
        return new PreparedStmtHolder(){

            @Override
            protected PreparedStatement initStatement(List<ParameterSetter> program) {
                FromClause from = (FromClause)fromClauseSupplier.get();
                FromTerm fromTerm = (FromTerm)fromTermSupplier.get();
                if (fromTerm == null) {
                    fromTerm = new FromTerm(from.getParameters());
                }
                WhereTerm where = (WhereTerm)whereTermSupplier.get();
                fromTerm.programParams(program, dbAdaptor);
                where.programParams(program, dbAdaptor);
                return dbAdaptor.getRecordSetStatement(conn, from, where.getWhere(), (String)orderBySupplier.get(), (Long)offsetSupplier.get(), (Long)rowCountSupplier.get(), (Set)fieldsForStatementSupplier.get());
            }
        };
    }
}

