/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.RepeatedParseException;
import ru.curs.celesta.score.CelestaParser;
import ru.curs.celesta.score.ChecksumInputStream;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TokenMgrError;
import ru.curs.celesta.score.discovery.ScoreByScorePathDiscovery;
import ru.curs.celesta.score.discovery.ScoreDiscovery;
import ru.curs.celesta.score.io.Resource;
import ru.curs.celesta.score.validator.IdentifierParser;

public abstract class AbstractScore {
    static final String DEPENDENCY_SCHEMA_DOES_NOT_EXIST_ERROR_TEMPLATE = "Couldn't parse schema '%s'. Dependency schema '%s' does not exist.";
    static final String CYCLIC_REFERENCES_ERROR_TEMPLATE = "Error parsing grain %s due to previous parsing errors or cycle reference involving grains '%s' and '%s'.";
    private final Map<String, Grain> grains = new HashMap<String, Grain>();
    private final Map<String, List<GrainPart>> grainNameToGrainParts = new LinkedHashMap<String, List<GrainPart>>();
    private int orderCounter;
    private final Set<GrainPart> currentlyParsingGrainParts = new HashSet<GrainPart>();

    protected AbstractScore() {
    }

    void init(ScoreDiscovery scoreDiscovery) throws ParseException {
        Set<Resource> grainResources = scoreDiscovery.discoverScore();
        this.initSystemGrain();
        this.fillGrainNameToGrainParts(grainResources);
        this.parseGrains(new StringBuilder());
    }

    private void fillGrainNameToGrainParts(Set<Resource> resources) throws ParseException {
        ArrayList<GrainPart> grainParts = new ArrayList<GrainPart>();
        for (Resource r : resources) {
            GrainPart grainPart = this.extractGrainInfo(r, false);
            grainParts.add(grainPart);
        }
        grainParts.sort((o1, o2) -> {
            if (o1.isDefinition() && !o2.isDefinition()) {
                return -1;
            }
            if (o1.isDefinition() == o2.isDefinition()) {
                return 0;
            }
            return 1;
        });
        for (GrainPart grainPart : grainParts) {
            String grainName = grainPart.getGrain().getName().replace("\"", "");
            if (!this.grainNameToGrainParts.containsKey(grainName)) {
                if (!grainPart.isDefinition()) {
                    throw new ParseException(String.format("Grain %s has no definition", grainName));
                }
                this.grainNameToGrainParts.put(grainName, new ArrayList());
            }
            this.grainNameToGrainParts.get(grainName).add(grainPart);
        }
    }

    private void parseGrains(StringBuilder errorScript) throws ParseException {
        for (String grainName : this.grainNameToGrainParts.keySet()) {
            try {
                this.parseGrain(grainName);
            }
            catch (ParseException e) {
                if (errorScript.length() > 0) {
                    errorScript.append("\n\n");
                }
                errorScript.append(e.getMessage());
            }
            if (errorScript.length() <= 0) continue;
            throw new ParseException(errorScript.toString());
        }
    }

    final void parseGrain(String grainName) throws ParseException {
        Grain g = this.grains.get(grainName);
        if (g.isParsingComplete()) {
            return;
        }
        ChecksumInputStream cis = null;
        for (GrainPart grainPart : this.grainNameToGrainParts.get(grainName)) {
            if (!this.currentlyParsingGrainParts.add(grainPart)) {
                throw new RepeatedParseException(grainPart);
            }
            cis = this.parseGrainPart(grainPart, cis);
        }
        g.setChecksum(cis.getCRC32());
        g.setLength(cis.getCount());
        g.finalizeParsing();
    }

    final void addGrain(Grain grain) throws ParseException {
        if (grain.getScore() != this) {
            throw new IllegalArgumentException();
        }
        if (this.grains.containsKey(grain.getName())) {
            throw new ParseException(String.format("Grain '%s' is already defined.", grain.getName()));
        }
        this.grains.put(grain.getName(), grain);
    }

    public Grain getGrain(String name) throws ParseException {
        Grain result = this.grains.get(name);
        if (result == null) {
            throw new ParseException(String.format("Unknown grain '%s'.", name));
        }
        return result;
    }

    final Grain getGrainAsDependency(Grain currentGrain, String dependencyGrainName) throws ParseException {
        Grain g = this.grains.get(dependencyGrainName);
        if (g == null) {
            throw new CelestaException(String.format(DEPENDENCY_SCHEMA_DOES_NOT_EXIST_ERROR_TEMPLATE, currentGrain.getName(), dependencyGrainName));
        }
        if (currentGrain == g) {
            return currentGrain;
        }
        if (g.isModified()) {
            try {
                this.parseGrain(dependencyGrainName);
            }
            catch (RepeatedParseException e) {
                AbstractScore.throwParseExceptionOnCyclicReferences(currentGrain.getName(), dependencyGrainName);
            }
        }
        if (!g.isParsingComplete()) {
            AbstractScore.throwParseExceptionOnCyclicReferences(currentGrain.getName(), dependencyGrainName);
        }
        return g;
    }

    private static void throwParseExceptionOnCyclicReferences(String currentGrainName, String dependencyGrainName) throws ParseException {
        throw new ParseException(String.format(CYCLIC_REFERENCES_ERROR_TEMPLATE, currentGrainName, currentGrainName, dependencyGrainName));
    }

    static String extractLineColNo(String msg) {
        Matcher matcher = Pattern.compile("at\\s+line\\s*(\\d+),?\\s*column\\s*(\\d+)").matcher(msg);
        if (matcher.find()) {
            return String.format(":%s:%s ", matcher.group(1), matcher.group(2));
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ChecksumInputStream parseGrainPart(GrainPart grainPart, ChecksumInputStream cis) throws ParseException {
        Resource r = grainPart.getSource();
        try (ChecksumInputStream is = cis == null ? new ChecksumInputStream(r.getInputStream()) : new ChecksumInputStream(r.getInputStream(), cis);){
            CelestaParser parser = new CelestaParser(is, "utf-8");
            try {
                parser.parseGrainPart(grainPart);
            }
            catch (ParseException | TokenMgrError e) {
                throw new ParseException(String.format("Error parsing %s%s: %s", r.toString(), AbstractScore.extractLineColNo(e.getMessage()), e.getMessage()));
            }
            ChecksumInputStream checksumInputStream = is;
            return checksumInputStream;
        }
        catch (FileNotFoundException e) {
            throw new ParseException(String.format("Cannot open resource '%s'.", r.toString()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private GrainPart extractGrainInfo(Resource r, boolean isSystem) throws ParseException {
        try {
            Throwable throwable = null;
            try (ChecksumInputStream is = isSystem ? new ChecksumInputStream(this.getSysSchemaInputStream()) : new ChecksumInputStream(r.getInputStream());){
                CelestaParser parser = new CelestaParser(is, "utf-8");
                try {
                    GrainPart grainPart = parser.extractGrainInfo(this, r);
                    return grainPart;
                }
                catch (ParseException | TokenMgrError e) {
                    try {
                        throw new ParseException(String.format("Error on extracting grain name '%s': %s", r.toString(), e.getMessage()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ParseException(String.format("Cannot open resource '%s'.", r.toString()));
        }
    }

    private void initSystemGrain() {
        ChecksumInputStream is = null;
        try {
            Grain result;
            GrainPart grainPart = this.extractGrainInfo(null, true);
            is = new ChecksumInputStream(this.getSysSchemaInputStream());
            CelestaParser parser = new CelestaParser(is, "utf-8");
            try {
                result = parser.parseGrainPart(grainPart);
            }
            catch (ParseException e) {
                throw new CelestaException(e.getMessage());
            }
            result.setChecksum(is.getCRC32());
            result.setLength(is.getCount());
            result.finalizeParsing();
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                is = null;
            }
        }
    }

    private InputStream getSysSchemaInputStream() {
        return this.getClass().getResourceAsStream(this.getSysSchemaName() + ".sql");
    }

    public abstract String getSysSchemaName();

    public abstract IdentifierParser getIdentifierParser();

    public Map<String, Grain> getGrains() {
        return Collections.unmodifiableMap(this.grains);
    }

    final int nextOrderCounter() {
        return ++this.orderCounter;
    }

    public final String describeGrains() {
        int maxGrainNameLen = "SCHEMA".length();
        int maxVersionLen = "VERSION".length();
        for (Grain g : this.grains.values()) {
            if (g.getName().length() > maxGrainNameLen) {
                maxGrainNameLen = g.getName().length();
            }
            if (g.getVersion().toString().length() <= maxVersionLen) continue;
            maxVersionLen = g.getVersion().toString().length();
        }
        StringBuilder builder = new StringBuilder(String.format("%n", new Object[0]));
        builder.append(String.format("%-" + maxGrainNameLen + "s | ", "SCHEMA"));
        builder.append(String.format("%-" + maxVersionLen + "s | CHECKSUM | %7s%n", "VERSION", "LENGTH"));
        for (Grain g : this.grains.values().stream().sorted(Comparator.comparing(NamedElement::getName)).collect(Collectors.toList())) {
            builder.append(String.format("%-" + maxGrainNameLen + "s | ", g.getName()));
            builder.append(String.format("%-" + maxVersionLen + "s | ", g.getVersion()));
            builder.append(String.format("%08X | % 7d%n", g.getChecksum(), g.getLength()));
        }
        return builder.toString();
    }

    public static final class ScoreBuilder<T extends AbstractScore> {
        private ScoreDiscovery scoreDiscovery;
        private Class<T> scoreClass;

        public ScoreBuilder(Class<T> scoreClass) {
            this.scoreClass = scoreClass;
        }

        @Deprecated
        public ScoreBuilder<T> path(String path) {
            this.scoreDiscovery = new ScoreByScorePathDiscovery(path);
            return this;
        }

        public ScoreBuilder<T> scoreDiscovery(ScoreDiscovery scoreDiscovery) {
            this.scoreDiscovery = scoreDiscovery;
            return this;
        }

        public T build() throws ParseException {
            try {
                AbstractScore t = (AbstractScore)this.scoreClass.newInstance();
                t.init(this.scoreDiscovery);
                return (T)t;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CelestaException(e);
            }
        }
    }
}

