/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.CelestaSerializer;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.io.Resource;

public final class GrainSaver {
    public void save(AbstractScore score, Resource scorePath) throws IOException {
        for (Grain g : score.getGrains().values()) {
            this.save(g, scorePath);
        }
    }

    public void save(Grain grain, Resource scorePath) throws IOException {
        String grainName = grain.getName();
        Resource output = scorePath.createRelative(grain.getNamespace()).createRelative(grainName + ".sql");
        for (GrainPart gp : grain.getGrainParts()) {
            Resource source = gp.getSource();
            if (!scorePath.contains(source) || source.equals(output)) continue;
            source.delete();
        }
        OutputStream outputStream = output.getOutputStream();
        if (outputStream == null) {
            throw new IOException(String.format("Cannot save '%s' grain script to resouce %s. The resource is not writable!", grainName, output.toString()));
        }
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            CelestaSerializer serializer = new CelestaSerializer(pw);
            serializer.save(grain);
        }
    }
}

