/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.LogicValuedExpr;
import ru.curs.celesta.score.ParseException;

final class In
extends LogicValuedExpr {
    private final Expr left;
    private final List<Expr> operands;

    In(Expr left, List<Expr> operands) {
        this.operands = operands;
        this.left = left;
    }

    public Expr getLeft() {
        return this.left;
    }

    public List<Expr> getOperands() {
        return this.operands;
    }

    @Override
    public List<Expr> getAllOperands() {
        return Stream.of(Arrays.asList(this.left), this.getOperands()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public void accept(ExprVisitor visitor) throws ParseException {
        this.left.accept(visitor);
        for (Expr operand : this.operands) {
            operand.accept(visitor);
        }
        visitor.visitIn(this);
    }
}

