/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.ArrayList;
import java.util.List;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.ReadOnlyTable;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.ZonedDateTimeColumn;

final class TableBuilder {
    private final GrainPart grainPart;
    private final String name;
    private List<BuildAction> actions = new ArrayList<BuildAction>();
    private BasicTable table;
    private boolean isReadOnly;

    TableBuilder(BasicTable table) {
        this(table.getGrainPart(), table.getName());
        this.table = table;
    }

    TableBuilder(GrainPart grainPart, String name) {
        this.grainPart = grainPart;
        this.name = name;
    }

    public Grain getGrain() {
        return this.grainPart.getGrain();
    }

    public BasicTable build() throws ParseException {
        if (this.table == null) {
            this.table = this.isReadOnly ? new ReadOnlyTable(this.grainPart, this.name) : new Table(this.grainPart, this.name);
        }
        for (BuildAction action : this.actions) {
            action.execute();
        }
        this.table.finalizePK();
        return this.table;
    }

    public void setCelestaDocLexem(String celestaDoc) {
        this.actions.add(() -> this.table.setCelestaDocLexem(celestaDoc));
    }

    public void setVersioned(boolean isVersioned) {
        this.actions.add(() -> {
            if (!this.isReadOnly) {
                ((Table)this.table).setVersioned(isVersioned);
            }
        });
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setAutoUpdate(boolean isAutoUpdate) {
        this.actions.add(() -> this.table.setAutoUpdate(isAutoUpdate));
    }

    public void addPK(String name) {
        this.actions.add(() -> this.table.addPK(name));
    }

    public void finalizePK() {
        this.actions.add(() -> this.table.finalizePK());
    }

    public void setPkConstraintName(String pkConstraintName) {
        this.actions.add(() -> this.table.setPkConstraintName(pkConstraintName));
    }

    public ColumnBuilder integerColumn(String columnName) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new IntegerColumn(this.table, columnName));
        return cb;
    }

    public ColumnBuilder floatingColumn(String columnName) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new FloatingColumn(this.table, columnName));
        return cb;
    }

    public ColumnBuilder decimalColumn(String columnName, int precision, int scale) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new DecimalColumn(this.table, columnName, precision, scale));
        return cb;
    }

    public ColumnBuilder stringColumn(String columnName) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new StringColumn(this.table, columnName));
        return cb;
    }

    public ColumnBuilder binaryColumn(String columnName) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new BinaryColumn(this.table, columnName));
        return cb;
    }

    public ColumnBuilder zonedDateTimeColumn(String columnName) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new ZonedDateTimeColumn(this.table, columnName));
        return cb;
    }

    public ColumnBuilder dateTimeColumn(String columnName) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new DateTimeColumn(this.table, columnName));
        return cb;
    }

    public ColumnBuilder booleanColumn(String columnName) {
        ColumnBuilder cb = new ColumnBuilder(columnName);
        this.actions.add(() -> cb.column = new BooleanColumn(this.table, columnName));
        return cb;
    }

    public ForeignKeyBuilder foreignKey() {
        ForeignKeyBuilder fkb = new ForeignKeyBuilder();
        this.actions.add(() -> fkb.foreignKey = new ForeignKey(this.table));
        return fkb;
    }

    public final class ForeignKeyBuilder {
        private ForeignKey foreignKey;

        private ForeignKeyBuilder() {
        }

        public void addColumn(String columnName) {
            TableBuilder.this.actions.add(() -> this.foreignKey.addColumn(columnName));
        }

        public void setConstraintName(String constraintName) {
            TableBuilder.this.actions.add(() -> this.foreignKey.setConstraintName(constraintName));
        }

        public void setReferencedTable(String grain, String table) {
            TableBuilder.this.actions.add(() -> this.foreignKey.setReferencedTable(grain, table));
        }

        public void addReferencedColumn(String columnName) {
            TableBuilder.this.actions.add(() -> this.foreignKey.addReferencedColumn(columnName));
        }

        public void finalizeReference() {
            TableBuilder.this.actions.add(() -> this.foreignKey.finalizeReference());
        }

        public void setUpdateRule(FKRule updateBehaviour) {
            TableBuilder.this.actions.add(() -> this.foreignKey.setUpdateRule(updateBehaviour));
        }

        public void setDeleteRule(FKRule deleteBehaviour) {
            TableBuilder.this.actions.add(() -> this.foreignKey.setDeleteRule(deleteBehaviour));
        }
    }

    public final class ColumnBuilder {
        private final String columnName;
        private Column<?> column;

        private ColumnBuilder(String columnName) {
            this.columnName = columnName;
        }

        public String getName() {
            return this.columnName;
        }

        public void setLength(String length) {
            TableBuilder.this.actions.add(() -> ((StringColumn)this.column).setLength(length));
        }

        public void setNullableAndDefault(boolean nullable, String defaultValue) {
            TableBuilder.this.actions.add(() -> this.column.setNullableAndDefault(nullable, defaultValue));
        }

        public void setCelestaDocLexem(String celestaDoc) {
            TableBuilder.this.actions.add(() -> this.column.setCelestaDocLexem(celestaDoc));
        }
    }

    @FunctionalInterface
    private static interface BuildAction {
        public void execute() throws ParseException;
    }
}

