/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score.validator;

import java.util.regex.Pattern;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.validator.IdentifierParser;

public final class PlainIdentifierParser
extends IdentifierParser {
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_]*");

    @Override
    void validate(String name) throws ParseException {
        super.validate(name);
        if (name.length() > 30) {
            throw new ParseException(String.format("Identifier '%s' is longer than %d characters.", name, 30));
        }
    }

    @Override
    String strip(String name) {
        return name;
    }

    @Override
    Pattern getNamePattern() {
        return NAME_PATTERN;
    }
}

