/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.ICallContext;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbFkInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.dbutils.meta.DbPkInfo;
import ru.curs.celesta.dbutils.meta.DbSequenceInfo;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.VersionString;
import ru.curs.celesta.score.View;
import ru.curs.celesta.syscursors.ISchemaCursor;

public abstract class DbUpdater<T extends ICallContext> {
    private static final Comparator<Grain> GRAIN_COMPARATOR = Comparator.comparingInt(Grain::getDependencyOrder);
    private static final Set<Integer> EXPECTED_STATUSES = new HashSet<Integer>();
    protected final DBAdaptor dbAdaptor;
    protected final AbstractScore score;
    protected final ConnectionPool connectionPool;
    protected ISchemaCursor schemaCursor;
    private final boolean forceDdInitialize;

    public DbUpdater(ConnectionPool connectionPool, AbstractScore score, boolean forceDdInitialize, DBAdaptor dbAdaptor) {
        this.connectionPool = connectionPool;
        this.score = score;
        this.forceDdInitialize = forceDdInitialize;
        this.dbAdaptor = dbAdaptor;
    }

    protected abstract T createContext();

    protected abstract void initDataAccessors(T var1);

    protected abstract String getSchemasTableName();

    public void updateSystemSchema() {
        try (T context = this.createContext();){
            this.updateSystemSchema(context);
        }
    }

    private void updateSystemSchema(T context) {
        this.initDataAccessors(context);
        Connection conn = context.getConn();
        if (!this.dbAdaptor.tableExists(conn, this.score.getSysSchemaName(), this.getSchemasTableName())) {
            if (this.dbAdaptor.userTablesExist() && !this.forceDdInitialize) {
                throw new CelestaException("No %s.%s table found in non-empty database.", this.score.getSysSchemaName(), this.getSchemasTableName());
            }
            this.updateSysGrain(context);
        }
    }

    public void updateDb() {
        String sysSchemaName = this.score.getSysSchemaName();
        try (T context = this.createContext();){
            this.updateSystemSchema(context);
            HashMap<String, GrainInfo> dbGrains = new HashMap<String, GrainInfo>();
            while (this.schemaCursor.nextInSet()) {
                if (!EXPECTED_STATUSES.contains(this.schemaCursor.getState())) {
                    throw new CelestaException("Cannot proceed with database upgrade: there are %s not in 'ready', 'recover' or 'lock' state.", this.getSchemasTableName());
                }
                GrainInfo gi = new GrainInfo();
                gi.checksum = (int)Long.parseLong(this.schemaCursor.getChecksum(), 16);
                gi.length = this.schemaCursor.getLength();
                gi.recover = this.schemaCursor.getState() == 3;
                gi.lock = this.schemaCursor.getState() == 4;
                try {
                    gi.version = new VersionString(this.schemaCursor.getVersion());
                }
                catch (ParseException e) {
                    throw new CelestaException(String.format("Error while scanning %s.%s table: %s", sysSchemaName, this.getSchemasTableName(), e.getMessage()));
                }
                dbGrains.put(this.schemaCursor.getId(), gi);
            }
            ArrayList<Grain> grains = new ArrayList<Grain>(this.score.getGrains().values());
            Collections.sort(grains, GRAIN_COMPARATOR);
            boolean success = true;
            for (Grain g : grains) {
                if (!g.isAutoupdate()) continue;
                GrainInfo gi = (GrainInfo)dbGrains.get(g.getName());
                if (gi == null) {
                    this.insertGrainRec(g);
                    success = this.updateGrain(g, this.connectionPool) & success;
                    continue;
                }
                success = this.decideToUpgrade(g, gi, this.connectionPool) & success;
            }
            if (!success) {
                throw new CelestaException("Not all %s were updated successfully, see %s.%s table data for details.", this.getSchemasTableName(), sysSchemaName, this.getSchemasTableName());
            }
        }
    }

    void updateSysGrain(T context) {
        try {
            Connection conn = context.getConn();
            Grain sys = this.score.getGrain(this.score.getSysSchemaName());
            this.createSysObjects(conn, sys);
            this.insertGrainRec(sys);
            if (!this.updateGrain(sys, this.connectionPool)) {
                throw new CelestaException("System grain '%s' update failed.", this.score.getSysSchemaName());
            }
        }
        catch (ParseException e) {
            throw new CelestaException("No '%s' grain definition found.", this.score.getSysSchemaName());
        }
    }

    void createSysObjects(Connection conn, Grain sys) throws ParseException {
        this.dbAdaptor.createSchemaIfNotExists(this.score.getSysSchemaName());
        this.dbAdaptor.createTable(conn, sys.getElement(this.getSchemasTableName(), BasicTable.class));
        this.dbAdaptor.createSysObjects(conn, this.score.getSysSchemaName());
    }

    private void insertGrainRec(Grain g) {
        this.schemaCursor.init();
        this.schemaCursor.setId(g.getName()).setVersion(g.getVersion().toString()).setLength(g.getLength()).setChecksum(String.format("%08X", g.getChecksum())).setState(3).setLastmodified(new Date()).setMessage("").insert();
    }

    private boolean decideToUpgrade(Grain g, GrainInfo gi, ConnectionPool connectionPool) {
        if (gi.lock) {
            return true;
        }
        if (gi.recover) {
            return this.updateGrain(g, connectionPool);
        }
        switch (g.getVersion().compareTo(gi.version)) {
            case LOWER: {
                throw new CelestaException("Grain '%s' version '%s' is lower than database grain version '%s'. Will not proceed with auto-upgrade.", g.getName(), g.getVersion().toString(), gi.version.toString());
            }
            case INCONSISTENT: {
                throw new CelestaException("Grain '%s' version '%s' is inconsistent with database grain version '%s'. Will not proceed with auto-upgrade.", g.getName(), g.getVersion().toString(), gi.version.toString());
            }
            case GREATER: {
                return this.updateGrain(g, connectionPool);
            }
            case EQUALS: {
                if (gi.length == g.getLength() && gi.checksum == g.getChecksum()) break;
                return this.updateGrain(g, connectionPool);
            }
        }
        return true;
    }

    boolean updateGrain(Grain g, ConnectionPool connectionPool) {
        this.schemaCursor.get(g.getName());
        this.schemaCursor.setState(1);
        this.schemaCursor.update();
        connectionPool.commit(this.schemaCursor.callContext().getConn());
        try {
            this.dbAdaptor.createSchemaIfNotExists(g.getName());
            this.beforeGrainUpdating(g);
            this.dropAllViews(g);
            this.dropAllParameterizedViews(g);
            this.dropOrphanedGrainIndices(g);
            List<DbFkInfo> dbFKeys = this.dropOrphanedGrainFKeys(g);
            HashSet<String> modifiedTablesMap = new HashSet<String>();
            this.updateSequences(g);
            for (BasicTable t : g.getElements(BasicTable.class).values()) {
                if (!this.updateTable(t, dbFKeys)) continue;
                modifiedTablesMap.add(t.getName());
            }
            this.updateGrainIndices(g);
            this.updateGrainFKeys(g);
            this.createViews(g);
            this.createParameterizedViews(g);
            for (MaterializedView mv : g.getElements(MaterializedView.class).values()) {
                String tableName = mv.getRefTable().getTable().getName();
                this.updateMaterializedView(mv, modifiedTablesMap.contains(tableName));
            }
            for (BasicTable t : g.getElements(BasicTable.class).values()) {
                Connection conn = this.schemaCursor.callContext().getConn();
                this.dbAdaptor.dropTableTriggersForMaterializedViews(conn, t);
                this.dbAdaptor.createTableTriggersForMaterializedViews(conn, t);
            }
            this.processGrainMeta(g);
            this.afterGrainUpdating(g);
            this.schemaCursor.setState(0);
            this.schemaCursor.setChecksum(String.format("%08X", g.getChecksum()));
            this.schemaCursor.setLength(g.getLength());
            this.schemaCursor.setLastmodified(new Date());
            this.schemaCursor.setMessage("");
            this.schemaCursor.setVersion(g.getVersion().toString());
            this.schemaCursor.update();
            connectionPool.commit(this.schemaCursor.callContext().getConn());
            return true;
        }
        catch (CelestaException e) {
            String newMsg = "";
            try {
                this.schemaCursor.callContext().getConn().rollback();
            }
            catch (SQLException e1) {
                newMsg = ", " + e1.getMessage();
            }
            this.schemaCursor.setState(2);
            this.schemaCursor.setMessage(String.format("%s/%d/%08X: %s", g.getVersion().toString(), g.getLength(), g.getChecksum(), e.getMessage() + newMsg));
            this.schemaCursor.update();
            connectionPool.commit(this.schemaCursor.callContext().getConn());
            return false;
        }
    }

    protected void beforeGrainUpdating(Grain g) {
    }

    protected void afterGrainUpdating(Grain g) {
    }

    protected abstract void processGrainMeta(Grain var1);

    void createViews(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        for (View v : g.getElements(View.class).values()) {
            this.dbAdaptor.createView(conn, v);
        }
    }

    void dropAllViews(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        for (String viewName : this.dbAdaptor.getViewList(conn, g)) {
            this.dbAdaptor.dropView(conn, g.getName(), viewName);
        }
    }

    void createParameterizedViews(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        for (ParameterizedView pv : g.getElements(ParameterizedView.class).values()) {
            this.dbAdaptor.createParameterizedView(conn, pv);
        }
    }

    void updateSequences(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        for (SequenceElement s : g.getElements(SequenceElement.class).values()) {
            if (this.dbAdaptor.sequenceExists(conn, g.getName(), s.getName())) {
                DbSequenceInfo sequenceInfo = this.dbAdaptor.getSequenceInfo(conn, s);
                if (!sequenceInfo.reflects(s)) continue;
                this.dbAdaptor.alterSequence(conn, s);
                continue;
            }
            this.dbAdaptor.createSequence(conn, s);
        }
    }

    void dropAllParameterizedViews(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        for (String viewName : this.dbAdaptor.getParameterizedViewList(conn, g)) {
            this.dbAdaptor.dropParameterizedView(conn, g.getName(), viewName);
        }
    }

    void updateGrainFKeys(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        HashMap<String, DbFkInfo> dbFKeys = new HashMap<String, DbFkInfo>();
        for (DbFkInfo dbi : this.dbAdaptor.getFKInfo(conn, g)) {
            dbFKeys.put(dbi.getName(), dbi);
        }
        for (BasicTable t : g.getElements(BasicTable.class).values()) {
            if (!t.isAutoUpdate()) continue;
            for (ForeignKey fk : t.getForeignKeys()) {
                if (dbFKeys.containsKey(fk.getConstraintName())) {
                    DbFkInfo dbi = (DbFkInfo)dbFKeys.get(fk.getConstraintName());
                    if (dbi.reflects(fk)) continue;
                    this.dbAdaptor.dropFK(conn, g.getName(), dbi.getTableName(), dbi.getName());
                    this.dbAdaptor.createFK(conn, fk);
                    continue;
                }
                this.dbAdaptor.createFK(conn, fk);
            }
        }
    }

    List<DbFkInfo> dropOrphanedGrainFKeys(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        List<DbFkInfo> dbFKeys = this.dbAdaptor.getFKInfo(conn, g);
        HashMap<String, ForeignKey> fKeys = new HashMap<String, ForeignKey>();
        for (BasicTable t : g.getElements(BasicTable.class).values()) {
            for (ForeignKey fk : t.getForeignKeys()) {
                fKeys.put(fk.getConstraintName(), fk);
            }
        }
        Iterator<DbFkInfo> i = dbFKeys.iterator();
        while (i.hasNext()) {
            DbFkInfo dbFKey = i.next();
            ForeignKey fKey = (ForeignKey)fKeys.get(dbFKey.getName());
            if (fKey != null && dbFKey.reflects(fKey)) continue;
            this.dbAdaptor.dropFK(conn, g.getName(), dbFKey.getTableName(), dbFKey.getName());
            i.remove();
        }
        return dbFKeys;
    }

    void dropOrphanedGrainIndices(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        Map<String, DbIndexInfo> dbIndices = this.dbAdaptor.getIndices(conn, g);
        Map<String, Index> myIndices = g.getIndices();
        for (DbIndexInfo dbIndexInfo : dbIndices.values()) {
            if (myIndices.containsKey(dbIndexInfo.getIndexName())) continue;
            this.dbAdaptor.dropIndex(g, dbIndexInfo);
        }
        block1: for (Map.Entry entry : myIndices.entrySet()) {
            DbIndexInfo dBIndexInfo = dbIndices.get(entry.getKey());
            if (dBIndexInfo == null) continue;
            boolean reflects = dBIndexInfo.reflects((Index)entry.getValue());
            if (!reflects) {
                this.dbAdaptor.dropIndex(g, dBIndexInfo);
            }
            for (Map.Entry<String, Column<?>> ee : ((Index)entry.getValue()).getColumns().entrySet()) {
                DbColumnInfo ci = this.dbAdaptor.getColumnInfo(conn, ee.getValue());
                if (ci != null && ci.reflects(ee.getValue())) continue;
                this.dbAdaptor.dropIndex(g, dBIndexInfo);
                continue block1;
            }
        }
    }

    void updateGrainIndices(Grain g) {
        Connection conn = this.schemaCursor.callContext().getConn();
        Map<String, DbIndexInfo> dbIndices = this.dbAdaptor.getIndices(conn, g);
        Map<String, Index> myIndices = g.getIndices();
        for (Map.Entry<String, Index> e : myIndices.entrySet()) {
            DbIndexInfo dBIndexInfo = dbIndices.get(e.getKey());
            if (dBIndexInfo != null) {
                boolean reflects = dBIndexInfo.reflects(e.getValue());
                if (reflects) continue;
                this.dbAdaptor.dropIndex(g, dBIndexInfo);
                this.dbAdaptor.createIndex(conn, e.getValue());
                continue;
            }
            this.dbAdaptor.createIndex(conn, e.getValue());
        }
    }

    boolean updateTable(BasicTable t, List<DbFkInfo> dbFKeys) {
        DbPkInfo pkInfo;
        Table tab;
        if (!t.isAutoUpdate()) {
            return false;
        }
        Connection conn = this.schemaCursor.callContext().getConn();
        if (!this.dbAdaptor.tableExists(conn, t.getGrain().getName(), t.getName())) {
            this.dbAdaptor.createTable(conn, t);
            return true;
        }
        Set<String> dbColumns = this.dbAdaptor.getColumns(conn, t);
        boolean modified = this.updateColumns(t, conn, dbColumns, dbFKeys);
        if (t instanceof Table && (tab = (Table)t).isVersioned()) {
            if (dbColumns.contains("recversion")) {
                DbColumnInfo ci = this.dbAdaptor.getColumnInfo(conn, tab.getRecVersionField());
                if (!ci.reflects(tab.getRecVersionField())) {
                    this.dbAdaptor.updateColumn(conn, tab.getRecVersionField(), ci);
                    modified = true;
                }
            } else {
                this.dbAdaptor.createColumn(conn, tab.getRecVersionField());
                modified = true;
            }
        }
        if ((pkInfo = this.dbAdaptor.getPKInfo(conn, t)).isEmpty()) {
            this.dbAdaptor.createPK(conn, t);
        }
        this.dbAdaptor.updateVersioningTrigger(conn, t);
        return modified;
    }

    void updateMaterializedView(MaterializedView mv, boolean refTableIsModified) {
        Connection conn = this.schemaCursor.callContext().getConn();
        boolean mViewExists = this.dbAdaptor.tableExists(conn, mv.getGrain().getName(), mv.getName());
        if (mViewExists) {
            if (!refTableIsModified) {
                String insertTriggerName = mv.getTriggerName(TriggerType.POST_INSERT);
                TriggerQuery query = new TriggerQuery().withSchema(mv.getGrain().getName()).withTableName(mv.getRefTable().getTable().getName()).withName(insertTriggerName);
                Optional<String> insertTriggerBody = this.dbAdaptor.getTriggerBody(conn, query);
                boolean checksumIsMatched = insertTriggerBody.map(b -> b.contains(String.format("/*CHECKSUM%sCHECKSUM*/", mv.getChecksum()))).orElse(false);
                if (checksumIsMatched) {
                    return;
                }
            }
            this.dbAdaptor.dropTable(conn, mv);
        }
        this.dbAdaptor.createTable(conn, mv);
        this.dbAdaptor.initDataForMaterializedView(conn, mv);
    }

    private boolean updateColumns(TableElement t, Connection conn, Set<String> dbColumns, List<DbFkInfo> dbFKeys) {
        DbPkInfo pkInfo = this.dbAdaptor.getPKInfo(conn, t);
        boolean result = false;
        boolean keyDropped = pkInfo.isEmpty();
        if (!pkInfo.reflects(t) && !keyDropped) {
            this.dropReferencedFKs(t, conn, dbFKeys);
            this.dbAdaptor.dropPk(conn, t, pkInfo.getName());
            keyDropped = true;
        }
        for (Map.Entry<String, Column<?>> e : t.getColumns().entrySet()) {
            if (dbColumns.contains(e.getKey())) {
                DbColumnInfo ci = this.dbAdaptor.getColumnInfo(conn, e.getValue());
                if (ci.reflects(e.getValue())) continue;
                if (t.getPrimaryKey().containsKey(e.getKey()) && !keyDropped) {
                    this.dropReferencedFKs(t, conn, dbFKeys);
                    this.dbAdaptor.dropPk(conn, t, pkInfo.getName());
                    keyDropped = true;
                }
                this.dbAdaptor.updateColumn(conn, e.getValue(), ci);
                result = true;
                continue;
            }
            this.dbAdaptor.createColumn(conn, e.getValue());
            result = true;
        }
        return result;
    }

    private void dropReferencedFKs(TableElement t, Connection conn, List<DbFkInfo> dbFKeys) {
        Iterator<DbFkInfo> i = dbFKeys.iterator();
        while (i.hasNext()) {
            DbFkInfo dbFKey = i.next();
            if (!t.getGrain().getName().equals(dbFKey.getRefGrainName()) || !t.getName().equals(dbFKey.getRefTableName())) continue;
            this.dbAdaptor.dropFK(conn, t.getGrain().getName(), dbFKey.getTableName(), dbFKey.getName());
            i.remove();
        }
    }

    static {
        EXPECTED_STATUSES.add(0);
        EXPECTED_STATUSES.add(3);
        EXPECTED_STATUSES.add(4);
    }

    class GrainInfo {
        private boolean recover;
        private boolean lock;
        private int length;
        private int checksum;
        private VersionString version;

        GrainInfo() {
        }
    }
}

