/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.StaticDataAdaptor;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefinerFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlAdaptor;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.function.CommonFunctions;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbFkInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.dbutils.meta.DbPkInfo;
import ru.curs.celesta.dbutils.meta.DbSequenceInfo;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Table;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.View;
import ru.curs.celesta.score.ZonedDateTimeColumn;

public abstract class DBAdaptor
implements QueryBuildingHelper,
StaticDataAdaptor {
    static final List<Class<? extends Column<?>>> COLUMN_CLASSES = Arrays.asList(IntegerColumn.class, StringColumn.class, BooleanColumn.class, FloatingColumn.class, DecimalColumn.class, BinaryColumn.class, DateTimeColumn.class, ZonedDateTimeColumn.class);
    static final String COLUMN_NAME = "COLUMN_NAME";
    private static final Logger LOGGER = LoggerFactory.getLogger(DBAdaptor.class);
    protected final ConnectionPool connectionPool;
    DdlAdaptor ddlAdaptor;

    protected DBAdaptor(ConnectionPool connectionPool, DdlConsumer ddlConsumer) {
        this.connectionPool = connectionPool;
        this.ddlAdaptor = new DdlAdaptor(this.getDdlGenerator(), ddlConsumer);
        connectionPool.setDbAdaptor(this);
    }

    abstract DdlGenerator getDdlGenerator();

    static PreparedStatement prepareStatement(Connection conn, String sql) {
        try {
            return conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    static String getTableFieldsListExceptBlobs(DataGrainElement t, Set<String> fields) {
        Predicate<ColumnMeta> notBinary = c -> !"BLOB".equals(c.getCelestaType());
        List<String> flds = fields.isEmpty() ? t.getColumns().entrySet().stream().filter(e -> notBinary.test((ColumnMeta)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()) : fields.stream().filter(f -> notBinary.test(t.getColumns().get(f))).collect(Collectors.toList());
        if (t instanceof Table && ((Table)t).isVersioned()) {
            flds.add("recversion");
        }
        return CommonFunctions.getFieldList(flds);
    }

    static FKRule getFKRule(String rule) {
        if ("NO ACTION".equalsIgnoreCase(rule) || "RECTRICT".equalsIgnoreCase(rule)) {
            return FKRule.NO_ACTION;
        }
        if ("SET NULL".equalsIgnoreCase(rule)) {
            return FKRule.SET_NULL;
        }
        if ("CASCADE".equalsIgnoreCase(rule)) {
            return FKRule.CASCADE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<String> sqlToStringSet(Connection conn, String sql) {
        HashSet<String> result = new HashSet<String>();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            try {
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    final String getSelectFromOrderBy(FromClause from, String whereClause, String orderBy, Set<String> fields) {
        String fieldList = DBAdaptor.getTableFieldsListExceptBlobs(from.getGe(), fields);
        String sqlfrom = String.format("select %s from %s", fieldList, from.getExpression());
        String sqlwhere = "".equals(whereClause) ? "" : " where " + whereClause;
        return sqlfrom + sqlwhere + " order by " + orderBy;
    }

    String constantFromSql() {
        return "";
    }

    String prepareRowColumnForSelectStaticStrings(String value, String colName, int maxStringLength) {
        return "? as " + colName;
    }

    final ColumnDefiner getColumnDefiner(Class<? extends Column<?>> c) {
        return ColumnDefinerFactory.getColumnDefiner(this.getType(), c);
    }

    abstract String getLimitedSQL(FromClause var1, String var2, String var3, long var4, long var6, Set<String> var8);

    abstract String getSelectTriggerBodySql(TriggerQuery var1);

    abstract boolean userTablesExist(Connection var1) throws SQLException;

    abstract void createSchemaIfNotExists(Connection var1, String var2);

    public final void dropTable(Connection conn, TableElement t) {
        this.ddlAdaptor.dropTable(conn, t);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean userTablesExist() {
        try (Connection conn = this.connectionPool.get();){
            boolean bl = this.userTablesExist(conn);
            return bl;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    public final void createSchemaIfNotExists(String name) {
        try (Connection conn = this.connectionPool.get();){
            this.createSchemaIfNotExists(conn, name);
            conn.commit();
        }
        catch (SQLException e) {
            throw new CelestaException("Cannot create schema. " + e.getMessage());
        }
    }

    public final void createColumn(Connection conn, Column<?> c) {
        this.ddlAdaptor.createColumn(conn, c);
    }

    public final PreparedStatement getUpdateRecordStatement(Connection conn, BasicTable t, boolean[] equalsMask, boolean[] nullsMask, List<ParameterSetter> program, String where) {
        StringBuilder setClause = new StringBuilder();
        if (t instanceof Table && ((Table)t).isVersioned()) {
            setClause.append(String.format("\"%s\" = ?", "recversion"));
            program.add(ParameterSetter.createForRecversion(this));
        }
        int i = 0;
        for (String c : t.getColumns().keySet()) {
            if (!equalsMask[i] && !t.getPrimaryKey().containsKey(c)) {
                CommonFunctions.padComma(setClause);
                if (nullsMask[i]) {
                    setClause.append(String.format("\"%s\" = NULL", c));
                } else {
                    setClause.append(String.format("\"%s\" = ?", c));
                    program.add(ParameterSetter.create(t.getColumnIndex(c), (QueryBuildingHelper)this));
                }
            }
            ++i;
        }
        String sql = String.format("update " + this.tableString(t.getGrain().getName(), t.getName()) + " set %s where %s", setClause.toString(), where);
        LOGGER.trace(sql);
        return DBAdaptor.prepareStatement(conn, sql);
    }

    public final void createIndex(Connection conn, Index index) {
        this.ddlAdaptor.createIndex(conn, index);
    }

    public final void createFK(Connection conn, ForeignKey fk) {
        this.ddlAdaptor.createFk(conn, fk);
    }

    public final void dropIndex(Grain g, DbIndexInfo dBIndexInfo) {
        try (Connection conn = this.connectionPool.get();){
            this.ddlAdaptor.dropIndex(conn, g, dBIndexInfo);
            conn.commit();
        }
        catch (SQLException | CelestaException e) {
            throw new CelestaException("Cannot drop index '%s': %s ", dBIndexInfo.getIndexName(), e.getMessage());
        }
    }

    public final PreparedStatement getRecordSetStatement(Connection conn, FromClause from, String whereClause, String orderBy, long offset, long rowCount, Set<String> fields) {
        String sql;
        if (offset == 0L && rowCount == 0L) {
            sql = this.getSelectFromOrderBy(from, whereClause, orderBy, fields);
        } else {
            sql = this.getLimitedSQL(from, whereClause, orderBy, offset, rowCount, fields);
            LOGGER.trace(sql);
        }
        try {
            PreparedStatement result = conn.prepareStatement(sql);
            return result;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    public final PreparedStatement getSetCountStatement(Connection conn, FromClause from, String whereClause) {
        String sql = "select count(*) from " + from.getExpression() + ("".equals(whereClause) ? "" : " where " + whereClause);
        PreparedStatement result = DBAdaptor.prepareStatement(conn, sql);
        return result;
    }

    public final void dropTrigger(Connection conn, TriggerQuery query) {
        this.ddlAdaptor.dropTrigger(conn, query);
    }

    public final void updateVersioningTrigger(Connection conn, TableElement t) {
        this.ddlAdaptor.updateVersioningTrigger(conn, t);
    }

    public final void createPK(Connection conn, TableElement t) {
        this.ddlAdaptor.createPk(conn, t);
    }

    @Override
    public final SQLGenerator getViewSQLGenerator() {
        return this.ddlAdaptor.getViewSQLGenerator();
    }

    public final void createView(Connection conn, View v) {
        this.ddlAdaptor.createView(conn, v);
    }

    public final void createParameterizedView(Connection conn, ParameterizedView pv) {
        this.ddlAdaptor.createParameterizedView(conn, pv);
    }

    public final void dropTableTriggersForMaterializedViews(Connection conn, BasicTable t) {
        this.ddlAdaptor.dropTableTriggersForMaterializedViews(conn, t);
    }

    public final void createTableTriggersForMaterializedViews(Connection conn, BasicTable t) {
        this.ddlAdaptor.createTableTriggersForMaterializedViews(conn, t);
    }

    public final void executeNative(Connection conn, String sql) {
        this.ddlAdaptor.executeNative(conn, sql);
    }

    public boolean isValidConnection(Connection conn, int timeout) {
        try {
            return conn.isValid(timeout);
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    public String tableString(String schemaName, String tableName) {
        return this.getSchemaDotNameQuotedTemplate(schemaName, tableName);
    }

    private String getSchemaDotNameQuotedTemplate(String schemaName, String name) {
        StringBuilder sb = new StringBuilder();
        if (schemaName.startsWith("\"")) {
            sb.append(schemaName);
        } else {
            sb.append("\"").append(schemaName).append("\"");
        }
        sb.append(".");
        if (name.startsWith("\"")) {
            sb.append(name);
        } else {
            sb.append("\"").append(name).append("\"");
        }
        return sb.toString();
    }

    public String sequenceString(String schemaName, String sequenceName) {
        return this.getSchemaDotNameQuotedTemplate(schemaName, sequenceName);
    }

    public String pkConstraintString(TableElement tableElement) {
        return tableElement.getPkConstraintName();
    }

    public void createTable(Connection conn, TableElement te) {
        this.ddlAdaptor.createTable(conn, te);
    }

    public Set<String> getColumns(Connection conn, TableElement t) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (ResultSet rs = conn.getMetaData().getColumns(null, t.getGrain().getName(), t.getName(), null);){
            while (rs.next()) {
                String rColumnName = rs.getString(COLUMN_NAME);
                result.add(rColumnName);
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e);
        }
        return result;
    }

    public void dropFK(Connection conn, String schemaName, String tableName, String fkName) {
        try {
            this.ddlAdaptor.dropFK(conn, schemaName, tableName, fkName);
        }
        catch (CelestaException e) {
            throw new CelestaException("Cannot drop foreign key '%s': %s", fkName, e.getMessage());
        }
    }

    public void dropParameterizedView(Connection conn, String schemaName, String viewName) {
        this.ddlAdaptor.dropParameterizedView(conn, schemaName, viewName);
    }

    public List<String> getViewList(Connection conn, Grain g) {
        String sql = String.format("select table_name from information_schema.views where table_schema = '%s'", g.getName());
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException | CelestaException e) {
            throw new CelestaException("Cannot get views list: %s", e.toString());
        }
        return result;
    }

    public String getCallFunctionSql(ParameterizedView pv) {
        return String.format(this.tableString(pv.getGrain().getName(), pv.getName()) + "(%s)", pv.getParameters().keySet().stream().map(p -> "?").collect(Collectors.joining(", ")));
    }

    public void createSequence(Connection conn, SequenceElement s) {
        this.ddlAdaptor.createSequence(conn, s);
    }

    public void alterSequence(Connection conn, SequenceElement s) {
        this.ddlAdaptor.alterSequence(conn, s);
    }

    public void dropSequence(Connection conn, SequenceElement s) {
        String sql = String.format("DROP SEQUENCE " + this.sequenceString(s.getGrain().getName(), s.getName()), new Object[0]);
        SqlUtils.executeUpdate(conn, sql);
    }

    public void dropView(Connection conn, String schemaName, String viewName) {
        this.ddlAdaptor.dropView(conn, schemaName, viewName);
    }

    public void createSysObjects(Connection conn, String sysSchemaName) {
    }

    @Override
    public String translateDate(String date) {
        try {
            DateTimeColumn.parseISODate(date);
        }
        catch (ParseException e) {
            throw new CelestaException(e.getMessage());
        }
        return date;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> getTriggerBody(Connection conn, TriggerQuery query) {
        String sql = this.getSelectTriggerBodySql(query);
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            Optional<String> result = rs.next() ? Optional.ofNullable(rs.getString(1)) : Optional.empty();
            Optional<String> optional = result;
            return optional;
        }
        catch (SQLException | CelestaException e) {
            throw new CelestaException("Could't select body of trigger %s", query.getName());
        }
    }

    public void initDataForMaterializedView(Connection conn, MaterializedView mv) {
        this.ddlAdaptor.initDataForMaterializedView(conn, mv);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> selectStaticStrings(List<String> data, String columnName, String orderByDirection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String orderByForSelectStaticStrings(String columnName, String orderByDirection) {
        return String.format("ORDER BY %s %s", columnName, orderByDirection);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int compareStrings(String left, String right) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean supportsCortegeComparing() {
        return false;
    }

    public void dropPk(Connection conn, TableElement t, String pkName) {
        this.ddlAdaptor.dropPk(conn, t, pkName);
    }

    public void updateColumn(Connection conn, Column<?> c, DbColumnInfo actual) {
        this.ddlAdaptor.updateColumn(conn, c, actual);
    }

    @Override
    public ZonedDateTime prepareZonedDateTimeForParameterSetter(Connection conn, ZonedDateTime z) {
        return z;
    }

    public abstract PreparedStatement getNavigationStatement(Connection var1, FromClause var2, String var3, String var4, Set<String> var5, long var6);

    public abstract boolean tableExists(Connection var1, String var2, String var3);

    public abstract boolean triggerExists(Connection var1, TriggerQuery var2) throws SQLException;

    public abstract PreparedStatement getOneRecordStatement(Connection var1, TableElement var2, String var3, Set<String> var4);

    public abstract PreparedStatement getOneFieldStatement(Connection var1, Column<?> var2, String var3);

    public abstract PreparedStatement deleteRecordSetStatement(Connection var1, TableElement var2, String var3);

    public abstract PreparedStatement getInsertRecordStatement(Connection var1, BasicTable var2, boolean[] var3, List<ParameterSetter> var4);

    public abstract int getCurrentIdent(Connection var1, BasicTable var2);

    public abstract PreparedStatement getDeleteRecordStatement(Connection var1, TableElement var2, String var3);

    public abstract DbColumnInfo getColumnInfo(Connection var1, Column<?> var2);

    public abstract DbPkInfo getPKInfo(Connection var1, TableElement var2);

    public abstract List<DbFkInfo> getFKInfo(Connection var1, Grain var2);

    public abstract Map<String, DbIndexInfo> getIndices(Connection var1, Grain var2);

    public abstract List<String> getParameterizedViewList(Connection var1, Grain var2);

    public abstract int getDBPid(Connection var1);

    public abstract DBType getType();

    public abstract long nextSequenceValue(Connection var1, SequenceElement var2);

    public abstract boolean sequenceExists(Connection var1, String var2, String var3);

    public abstract DbSequenceInfo getSequenceInfo(Connection var1, SequenceElement var2);

    private /* synthetic */ String lambda$compareStrings$6(int maxStringLength, String comparison) {
        return "SELECT COUNT(*)  FROM ( SELECT " + this.prepareRowColumnForSelectStaticStrings("?", "a", maxStringLength) + " " + this.constantFromSql() + ") r  WHERE a " + comparison + " ?";
    }

    private static /* synthetic */ void lambda$selectStaticStrings$5(PreparedStatement ps, AtomicInteger paramCounter, String str) {
        try {
            ps.setString(paramCounter.getAndIncrement(), str);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ String lambda$selectStaticStrings$4(String columnName, int maxStringLength, String str) {
        String rowStr = this.prepareRowColumnForSelectStaticStrings(str, columnName, maxStringLength);
        return String.format("SELECT %s %s", rowStr, this.constantFromSql());
    }
}

