/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.ddl.FirebirdDdlGenerator;
import ru.curs.celesta.dbutils.adaptors.function.SchemalessFunctions;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbFkInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.dbutils.meta.DbPkInfo;
import ru.curs.celesta.dbutils.meta.DbSequenceInfo;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.validator.AnsiQuotedIdentifierParser;

public final class FirebirdAdaptor
extends DBAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirebirdAdaptor.class);
    private static final Pattern TABLE_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9]*)_([a-zA-Z_][a-zA-Z0-9_]*)");
    private static final Pattern HEX_STRING = Pattern.compile("'([0-9A-F]+)'");
    private static final Pattern DATE_PATTERN = Pattern.compile("'(\\d\\d)\\.(\\d\\d)\\.(\\d\\d\\d\\d)'");
    private static final Pattern SEQUENCE_INFO_PATTERN = Pattern.compile("/\\* INCREMENT_BY = (.*), MINVALUE = (.*), MAXVALUE = (.*), CYCLE = (.*) \\*/");
    private static final String CUR_VALUE_PROC_POSTFIX = "curValueProc";
    private static final String NEXT_VALUE_PROC_POSTFIX = "nextValueProc";

    public FirebirdAdaptor(ConnectionPool connectionPool, DdlConsumer ddlConsumer) {
        super(connectionPool, ddlConsumer);
    }

    @Override
    DdlGenerator getDdlGenerator() {
        return new FirebirdDdlGenerator(this);
    }

    @Override
    String getLimitedSQL(FromClause from, String whereClause, String orderBy, long offset, long rowCount, Set<String> fields) {
        if (offset == 0L && rowCount == 0L) {
            throw new IllegalArgumentException();
        }
        String firstSql = "";
        if (rowCount != 0L) {
            firstSql = String.format("FIRST %s", rowCount);
        }
        String sqlwhere = "".equals(whereClause) ? "" : " WHERE " + whereClause;
        String fieldList = FirebirdAdaptor.getTableFieldsListExceptBlobs(from.getGe(), fields);
        String sql = String.format("SELECT %s SKIP %d %s FROM %s %s ORDER BY %s", firstSql, offset, fieldList, from.getExpression(), sqlwhere, orderBy);
        return sql;
    }

    @Override
    String getSelectTriggerBodySql(TriggerQuery query) {
        String sql = String.format("SELECT RDB$TRIGGER_SOURCE FROM RDB$TRIGGERS WHERE RDB$TRIGGER_NAME = '%s' AND RDB$RELATION_NAME = '%s_%s'", query.getName(), query.getSchema(), query.getTableName());
        return sql;
    }

    @Override
    boolean userTablesExist(Connection conn) throws SQLException {
        String sql = "SELECT COUNT(*) \nFROM RDB$RELATIONS RDB$RELATIONS \nWHERE RDB$SYSTEM_FLAG = 0";
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
    }

    @Override
    void createSchemaIfNotExists(Connection conn, String name) {
    }

    @Override
    public PreparedStatement getNavigationStatement(Connection conn, FromClause from, String orderBy, String navigationWhereClause, Set<String> fields, long offset) {
        boolean useWhere;
        if (navigationWhereClause == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder w = new StringBuilder(navigationWhereClause);
        String fieldList = FirebirdAdaptor.getTableFieldsListExceptBlobs(from.getGe(), fields);
        boolean bl = useWhere = w.length() > 0;
        if (orderBy.length() > 0) {
            w.append(" order by " + orderBy);
        }
        String sql = String.format("SELECT FIRST 1 SKIP %d %s FROM  %s %s;", offset == 0L ? 0L : offset - 1L, fieldList, from.getExpression(), useWhere ? " where " + w : w);
        LOGGER.trace(sql);
        return FirebirdAdaptor.prepareStatement(conn, sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean tableExists(Connection conn, String schema, String name) {
        String sql = String.format("SELECT count(*)%nFROM RDB$RELATIONS%nWHERE RDB$RELATION_NAME = '%s_%s'", schema, name);
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            rs.next();
            boolean result = rs.getInt(1) > 0;
            rs.close();
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
    }

    @Override
    public boolean triggerExists(Connection conn, TriggerQuery query) throws SQLException {
        String sql = String.format("SELECT count(*) FROM RDB$TRIGGERS%nWHERE %n  RDB$TRIGGER_NAME = '%s' AND RDB$RELATION_NAME = '%s_%s'", query.getName(), query.getSchema(), query.getTableName());
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            boolean result = rs.getInt(1) > 0;
            rs.close();
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public Set<String> getColumns(Connection conn, TableElement t) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(null, null, t.getGrain().getName() + "_" + t.getName(), null);){
                while (rs.next()) {
                    String rColumnName = rs.getString("COLUMN_NAME");
                    result.add(rColumnName);
                }
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    @Override
    public PreparedStatement getOneRecordStatement(Connection conn, TableElement t, String where, Set<String> fields) {
        String fieldList = FirebirdAdaptor.getTableFieldsListExceptBlobs((DataGrainElement)((Object)t), fields);
        String sql = String.format("select first 1 %s from %s where %s;", fieldList, this.tableString(t.getGrain().getName(), t.getName()), where);
        PreparedStatement result = FirebirdAdaptor.prepareStatement(conn, sql);
        LOGGER.trace("{}", (Object)result);
        return result;
    }

    @Override
    public PreparedStatement getOneFieldStatement(Connection conn, Column<?> c, String where) {
        TableElement t = c.getParentTable();
        String sql = String.format("select first 1 %s from %s where %s;", c.getQuotedName(), this.tableString(t.getGrain().getName(), t.getName()), where);
        return FirebirdAdaptor.prepareStatement(conn, sql);
    }

    @Override
    public PreparedStatement deleteRecordSetStatement(Connection conn, TableElement t, String where) {
        String sql = String.format("delete from " + this.tableString(t.getGrain().getName(), t.getName()) + " %s;", where.isEmpty() ? "" : "where " + where);
        try {
            return conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    @Override
    public PreparedStatement getInsertRecordStatement(Connection conn, BasicTable t, boolean[] nullsMask, List<ParameterSetter> program) {
        Iterator<String> columns = t.getColumns().keySet().iterator();
        StringBuilder fields = new StringBuilder();
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < t.getColumns().size(); ++i) {
            String c = columns.next();
            if (nullsMask[i]) continue;
            if (params.length() > 0) {
                fields.append(", ");
                params.append(", ");
            }
            params.append("?");
            fields.append('\"');
            fields.append(c);
            fields.append('\"');
            program.add(ParameterSetter.create(i, (QueryBuildingHelper)this));
        }
        String returning = "";
        for (Column column : t.getColumns().values()) {
            IntegerColumn ic;
            if (!(column instanceof IntegerColumn) || (ic = (IntegerColumn)column).getSequence() == null) continue;
            returning = " returning " + column.getQuotedName();
            break;
        }
        String sql = fields.length() == 0 && params.length() == 0 ? String.format("insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " default values %s;", returning) : String.format("insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " (%s) values (%s)%s;", fields.toString(), params.toString(), returning);
        return FirebirdAdaptor.prepareStatement(conn, sql);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getCurrentIdent(Connection conn, BasicTable t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PreparedStatement getDeleteRecordStatement(Connection conn, TableElement t, String where) {
        String sql = String.format("delete from " + this.tableString(t.getGrain().getName(), t.getName()) + " where %s;", where);
        return FirebirdAdaptor.prepareStatement(conn, sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DbColumnInfo getColumnInfo(Connection conn, Column<?> c) {
        String sql = String.format("SELECT r.RDB$FIELD_NAME AS column_name,%n        r.RDB$DESCRIPTION AS field_description,%n        r.RDB$NULL_FLAG AS nullable,%n        f.RDB$FIELD_LENGTH AS column_length,%n        f.RDB$FIELD_PRECISION AS column_precision,%n        f.RDB$FIELD_SCALE AS column_scale,%n        CASE f.RDB$FIELD_TYPE%n          WHEN 261 THEN 'BLOB'%n          WHEN 14 THEN 'CHAR'%n          WHEN 40 THEN 'CSTRING'%n          WHEN 11 THEN 'D_FLOAT'%n          WHEN 27 THEN 'DOUBLE PRECISION'%n          WHEN 10 THEN 'FLOAT'%n          WHEN 16 THEN 'BIGINT'%n          WHEN 8 THEN 'INTEGER'%n          WHEN 9 THEN 'QUAD'%n          WHEN 7 THEN 'SMALLINT'%n          WHEN 12 THEN 'DATE'%n          WHEN 13 THEN 'TIME'%n          WHEN 35 THEN 'TIMESTAMP'%n          WHEN 29 THEN 'TIMESTAMP WITH TIME ZONE'%n          WHEN 37 THEN 'VARCHAR'%n          ELSE 'UNKNOWN'%n        END AS column_type,%n        f.RDB$FIELD_SUB_TYPE AS column_subtype%n   FROM RDB$RELATION_FIELDS r%n   LEFT JOIN RDB$FIELDS f ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME%n   LEFT JOIN RDB$COLLATIONS coll ON f.RDB$COLLATION_ID = coll.RDB$COLLATION_ID%n   LEFT JOIN RDB$CHARACTER_SETS cset ON f.RDB$CHARACTER_SET_ID = cset.RDB$CHARACTER_SET_ID%n  WHERE r.RDB$RELATION_NAME='%s_%s' AND r.RDB$FIELD_NAME = '%s'", c.getParentTable().getGrain().getName(), c.getParentTable().getName(), c.getName());
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            if (rs.next()) {
                DbColumnInfo result = new DbColumnInfo();
                result.setName(rs.getString("column_name").trim());
                String columnType = rs.getString("column_type").trim();
                Integer columnSubType = rs.getInt("column_subtype");
                if (("BIGINT".equals(columnType) || "INTEGER".equals(columnType)) && Integer.valueOf(2).equals(columnSubType)) {
                    result.setType(DecimalColumn.class);
                    result.setLength(rs.getInt("column_precision"));
                    result.setScale(Math.abs(rs.getInt("column_scale")));
                } else if ("BLOB".equals(columnType) && Integer.valueOf(1).equals(columnSubType)) {
                    result.setType(StringColumn.class);
                    result.setMax(true);
                } else {
                    for (Class cc : COLUMN_CLASSES) {
                        if (!this.getColumnDefiner(cc).dbFieldType().equalsIgnoreCase(columnType)) continue;
                        result.setType(cc);
                        break;
                    }
                }
                result.setNullable(rs.getInt("nullable") != 1);
                if (result.getType() == StringColumn.class) {
                    result.setLength(rs.getInt("column_length"));
                }
                this.processDefaults(conn, c, result);
                DbColumnInfo dbColumnInfo = result;
                return dbColumnInfo;
            }
            DbColumnInfo dbColumnInfo = null;
            return dbColumnInfo;
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
    }

    private void processDefaults(Connection conn, Column<?> c, DbColumnInfo dbColumnInfo) throws SQLException {
        String defaultValue;
        block35: {
            defaultValue = null;
            TableElement te = c.getParentTable();
            Grain g = te.getGrain();
            String sql = String.format("SELECT r.RDB$DEFAULT_SOURCE AS column_default_value%n   FROM RDB$RELATION_FIELDS r%n   WHERE r.RDB$RELATION_NAME='%s_%s' AND r.RDB$FIELD_NAME = '%s'", c.getParentTable().getGrain().getName(), c.getParentTable().getName(), c.getName());
            try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
                Matcher m;
                rs.next();
                String defaultSource = rs.getString(1);
                if (defaultSource == null) {
                    if (!IntegerColumn.class.equals(dbColumnInfo.getType())) break block35;
                    String triggerName = SchemalessFunctions.generateSequenceTriggerName((IntegerColumn)c);
                    sql = String.format("SELECT proc.RDB$DEPENDED_ON_NAME %n FROM RDB$DEPENDENCIES tr%n JOIN RDB$DEPENDENCIES proc ON tr.RDB$DEPENDED_ON_NAME = proc.RDB$DEPENDENT_NAME%n WHERE tr.RDB$DEPENDENT_NAME = '%s' AND tr.RDB$DEPENDENT_TYPE = 2 AND tr.RDB$DEPENDED_ON_TYPE = 5%n AND proc.RDB$DEPENDENT_TYPE = 5 AND proc.RDB$DEPENDED_ON_TYPE = 14", triggerName);
                    try (ResultSet sequenceRs = SqlUtils.executeQuery(conn, sql);){
                        if (sequenceRs.next()) {
                            String sequenceName = sequenceRs.getString(1).trim();
                            defaultValue = "NEXTVAL(" + sequenceName.replace(g.getName() + "_", "") + ")";
                        }
                        break block35;
                    }
                }
                defaultValue = defaultSource.replace("default", "").trim();
                if (BooleanColumn.class.equals(dbColumnInfo.getType())) {
                    defaultValue = "0".equals(defaultValue) ? "'FALSE'" : "'TRUE'";
                } else if (DateTimeColumn.class.equals(dbColumnInfo.getType())) {
                    if ("current_timestamp".equalsIgnoreCase(defaultValue)) {
                        defaultValue = "GETDATE()";
                    } else {
                        Matcher m2 = DATE_PATTERN.matcher(defaultValue);
                        if (m2.find()) {
                            defaultValue = String.format("'%s%s%s'", m2.group(3), m2.group(2), m2.group(1));
                        }
                    }
                } else if (BinaryColumn.class.equals(dbColumnInfo.getType()) && (m = HEX_STRING.matcher(defaultValue)).find()) {
                    defaultValue = "0x" + m.group(1);
                }
            }
        }
        if (defaultValue != null) {
            dbColumnInfo.setDefaultValue(defaultValue);
        }
    }

    @Override
    public DbPkInfo getPKInfo(Connection conn, TableElement t) {
        String sql = String.format("select%n    ix.rdb$index_name as pk_name,%n    sg.rdb$field_name as column_name%n from%n    rdb$indices ix%n    left join rdb$index_segments sg on ix.rdb$index_name = sg.rdb$index_name%n    left join rdb$relation_constraints rc on rc.rdb$index_name = ix.rdb$index_name%n where%n    rc.rdb$constraint_type = 'PRIMARY KEY' AND rc.rdb$relation_name = '%s_%s'", t.getGrain().getName(), t.getName());
        DbPkInfo result = new DbPkInfo(this);
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            while (rs.next()) {
                if (result.getName() == null) {
                    String pkName = rs.getString("pk_name").trim();
                    result.setName(pkName);
                }
                String columnName = rs.getString("column_name").trim();
                result.addColumnName(columnName);
            }
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
        return result;
    }

    @Override
    public List<DbFkInfo> getFKInfo(Connection conn, Grain g) {
        String sql = String.format("SELECT    detail_relation_constraints.RDB$RELATION_NAME as table_name%n    , detail_relation_constraints.RDB$CONSTRAINT_NAME as constraint_name%n    , ref_constraints.RDB$UPDATE_RULE as update_rule%n    , ref_constraints.RDB$DELETE_RULE as delete_rule%n    , detail_index_segments.rdb$field_name AS column_name%n    , master_relation_constraints.rdb$relation_name AS ref_table_name%nFROM%n    rdb$relation_constraints detail_relation_constraints%n    JOIN rdb$index_segments detail_index_segments ON       detail_relation_constraints.rdb$index_name = detail_index_segments.rdb$index_name %n    JOIN rdb$ref_constraints ref_constraints ON       detail_relation_constraints.rdb$constraint_name = ref_constraints.rdb$constraint_name%n    JOIN rdb$relation_constraints master_relation_constraints ON       ref_constraints.rdb$const_name_uq = master_relation_constraints.rdb$constraint_name%nWHERE%n    detail_relation_constraints.rdb$constraint_type = 'FOREIGN KEY'%n    AND detail_relation_constraints.rdb$relation_name like '%s@_%%' escape '@'%nORDER BY table_name, constraint_name, detail_index_segments.rdb$field_position;", g.getName());
        HashMap<String, DbFkInfo> fks = new HashMap<String, DbFkInfo>();
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            while (rs.next()) {
                String fkName = rs.getString("constraint_name").trim();
                String fullTableName = rs.getString("table_name").trim();
                String tableName = this.convertNameFromDb(fullTableName, g);
                String fullRefTableName = rs.getString("ref_table_name").trim();
                String refGrainName = fullRefTableName.substring(0, fullRefTableName.indexOf("_"));
                String refTableName = fullRefTableName.substring(refGrainName.length() + 1);
                FKRule updateRule = FirebirdAdaptor.getFKRule(rs.getString("update_rule").trim());
                FKRule deleteRule = FirebirdAdaptor.getFKRule(rs.getString("delete_rule").trim());
                String columnName = rs.getString("column_name").trim();
                fks.computeIfAbsent(fkName, key -> {
                    DbFkInfo dfi = new DbFkInfo(fkName);
                    dfi.setTableName(tableName);
                    dfi.setRefGrainName(refGrainName);
                    dfi.setRefTableName(refTableName);
                    dfi.setDeleteRule(deleteRule);
                    dfi.setUpdateRule(updateRule);
                    return dfi;
                }).getColumnNames().add(columnName);
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return new ArrayList<DbFkInfo>(fks.values());
    }

    @Override
    public Map<String, DbIndexInfo> getIndices(Connection conn, Grain g) {
        String sql = String.format("SELECT RDB$INDICES.RDB$INDEX_NAME as indexname, RDB$INDICES.RDB$RELATION_NAME as tablename, RDB$INDEX_SEGMENTS.RDB$FIELD_NAME AS columnname%nFROM RDB$INDEX_SEGMENTS%nLEFT JOIN RDB$INDICES  ON RDB$INDICES.RDB$INDEX_NAME = RDB$INDEX_SEGMENTS.RDB$INDEX_NAME%nLEFT JOIN RDB$RELATION_CONSTRAINTS  ON RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME = RDB$INDEX_SEGMENTS.RDB$INDEX_NAME%nWHERE RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE IS NULL AND RDB$INDICES.RDB$RELATION_NAME like '%s@_%%' escape '@'%nORDER BY RDB$INDEX_SEGMENTS.RDB$FIELD_POSITION", g.getName());
        HashMap<String, DbIndexInfo> result = new HashMap<String, DbIndexInfo>();
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            DbIndexInfo i = null;
            while (rs.next()) {
                String tabName = rs.getString("tablename").trim();
                tabName = this.convertNameFromDb(tabName, g);
                String indName = rs.getString("indexname").trim();
                indName = this.convertNameFromDb(indName, g);
                if (i == null || !i.getTableName().equals(tabName) || !i.getIndexName().equals(indName)) {
                    i = new DbIndexInfo(tabName, indName);
                    result.put(indName, i);
                }
                i.getColumnNames().add(rs.getString("columnname").trim());
            }
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
        return result;
    }

    @Override
    public List<String> getParameterizedViewList(Connection conn, Grain g) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = String.format("SELECT RDB$PROCEDURE_NAME%nFROM RDB$PROCEDURES%nWHERE RDB$PROCEDURE_NAME LIKE '%s@_%%' escape '@' %nAND RDB$PROCEDURE_NAME NOT LIKE '%%curValueProc%%' escape '@' %nAND RDB$PROCEDURE_NAME NOT LIKE '%%nextValueProc%%' escape '@' %n", g.getName());
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            while (rs.next()) {
                String dbName = rs.getString(1).trim();
                result.add(this.convertNameFromDb(dbName, g));
            }
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDBPid(Connection conn) {
        try (ResultSet rs = SqlUtils.executeQuery(conn, "SELECT MON$SERVER_PID as pid FROM MON$ATTACHMENTS");){
            if (!rs.next()) return 0;
            int n = rs.getInt("pid");
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public DBType getType() {
        return DBType.FIREBIRD;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long nextSequenceValue(Connection conn, SequenceElement s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ZonedDateTime prepareZonedDateTimeForParameterSetter(Connection conn, ZonedDateTime z) {
        return z.withZoneSameInstant(ZoneId.systemDefault());
    }

    @Override
    public void dropSequence(Connection conn, SequenceElement s) {
        String nextValueProcName = FirebirdAdaptor.sequenceNextValueProcString(s.getGrain().getName(), s.getName());
        String sql = String.format("DROP PROCEDURE %s", nextValueProcName);
        SqlUtils.executeUpdate(conn, sql);
        String curValueProcName = FirebirdAdaptor.sequenceCurValueProcString(s.getGrain().getName(), s.getName());
        sql = String.format("DROP PROCEDURE %s", curValueProcName);
        SqlUtils.executeUpdate(conn, sql);
        super.dropSequence(conn, s);
    }

    public static String sequenceCurValueProcString(String schemaName, String sequenceName) {
        return FirebirdAdaptor.sequenceCurValueProcString(schemaName, sequenceName, true);
    }

    private static String sequenceCurValueProcString(String schemaName, String sequenceName, boolean isQuoted) {
        return FirebirdAdaptor.sequenceProcString(schemaName, sequenceName, "_curValueProc", isQuoted);
    }

    public static String sequenceNextValueProcString(String schemaName, String sequenceName) {
        return FirebirdAdaptor.sequenceNextValueProcString(schemaName, sequenceName, true);
    }

    private static String sequenceNextValueProcString(String schemaName, String sequenceName, boolean isQuoted) {
        return FirebirdAdaptor.sequenceProcString(schemaName, sequenceName, "_nextValueProc", isQuoted);
    }

    private static String sequenceProcString(String schemaName, String sequenceName, String procPostfix, boolean isQuoted) {
        StringBuilder sb = new StringBuilder(NamedElement.limitName(FirebirdAdaptor.getSchemaUnderscoreNameTemplate(schemaName, sequenceName), procPostfix));
        if (isQuoted) {
            sb.insert(0, '\"').append('\"');
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sequenceExists(Connection conn, String schema, String name) {
        String sql = String.format("SELECT * FROM RDB$GENERATORS WHERE RDB$GENERATOR_NAME = '%s'", this.sequenceString(schema, name, false));
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DbSequenceInfo getSequenceInfo(Connection conn, SequenceElement s) {
        String nextValueProcName = FirebirdAdaptor.sequenceNextValueProcString(s.getGrain().getName(), s.getName(), false);
        String sql = String.format("SELECT RDB$PROCEDURE_SOURCE FROM RDB$PROCEDURES WHERE RDB$PROCEDURE_NAME = '%s'", nextValueProcName);
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            rs.next();
            String body = rs.getString(1);
            Matcher matcher = SEQUENCE_INFO_PATTERN.matcher(body);
            matcher.find();
            DbSequenceInfo dbSequenceInfo = new DbSequenceInfo();
            dbSequenceInfo.setIncrementBy(Long.parseLong(matcher.group(1)));
            dbSequenceInfo.setMinValue(Long.parseLong(matcher.group(2)));
            dbSequenceInfo.setMaxValue(Long.parseLong(matcher.group(3)));
            dbSequenceInfo.setCycle(Boolean.parseBoolean(matcher.group(4)));
            DbSequenceInfo dbSequenceInfo2 = dbSequenceInfo;
            return dbSequenceInfo2;
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
    }

    @Override
    public boolean nullsFirst() {
        return false;
    }

    @Override
    public String getInFilterClause(DataGrainElement dge, DataGrainElement otherDge, List<String> fields, List<String> otherFields, String whereForOtherTable) {
        String template = "EXISTS (SELECT * FROM %s WHERE %s AND %s)";
        String tableStr = this.tableString(dge.getGrain().getName(), dge.getName());
        String otherTableStr = this.tableString(otherDge.getGrain().getName(), otherDge.getName());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            sb.append(tableStr).append(".\"").append(fields.get(i)).append("\"").append(" = ").append(otherTableStr).append(".\"").append(otherFields.get(i)).append("\"");
            if (i + 1 == fields.size()) continue;
            sb.append(" AND ");
        }
        String result = String.format(template, otherTableStr, sb.toString(), whereForOtherTable);
        return result;
    }

    @Override
    public void createSysObjects(Connection conn, String sysSchemaName) {
        String versionCheckErrorSql = "CREATE OR ALTER EXCEPTION VERSION_CHECK_ERROR 'record version check failure'";
        String sequenceOverflowErrorSql = "CREATE OR ALTER EXCEPTION SEQUENCE_OVERFLOW_ERROR 'sequence overflow failure'";
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(versionCheckErrorSql);
            stmt.executeUpdate(sequenceOverflowErrorSql);
        }
        catch (SQLException e) {
            throw new CelestaException("Could not create or alter versioncheck exception: %s", e.getMessage());
        }
    }

    @Override
    public List<String> getViewList(Connection conn, Grain g) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = String.format("select rdb$relation_name%nfrom rdb$relations%nwhere rdb$view_blr is not null %nand (rdb$system_flag is null or rdb$system_flag = 0)and rdb$relation_name like '%s@_%%' escape '@'", g.getName());
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            while (rs.next()) {
                String dbName = rs.getString(1).trim();
                result.add(this.convertNameFromDb(dbName, g));
            }
        }
        catch (Exception e) {
            throw new CelestaException(e);
        }
        return result;
    }

    @Override
    public String tableString(String schemaName, String tableName) {
        StringBuilder sb = new StringBuilder(FirebirdAdaptor.getSchemaUnderscoreNameTemplate(schemaName, tableName));
        sb.insert(0, '\"').append('\"');
        return sb.toString();
    }

    @Override
    public String pkConstraintString(TableElement tableElement) {
        return NamedElement.limitName(tableElement.getPkConstraintName() + "_" + tableElement.getGrain().getName());
    }

    @Override
    String constantFromSql() {
        return "FROM RDB$DATABASE";
    }

    @Override
    String prepareRowColumnForSelectStaticStrings(String value, String colName, int maxStringLength) {
        return String.format("CAST(? as varchar(%d)) as %s", maxStringLength, colName);
    }

    @Override
    String orderByForSelectStaticStrings(String columnName, String orderByDirection) {
        return String.format("ORDER BY 1 %s", orderByDirection);
    }

    private static String getSchemaUnderscoreNameTemplate(String schemaName, String name) {
        return FirebirdAdaptor.stripNameFromQuotes(schemaName) + "_" + FirebirdAdaptor.stripNameFromQuotes(name);
    }

    private static String stripNameFromQuotes(String name) {
        return name.startsWith("\"") ? name.substring(1, name.length() - 1) : name;
    }

    private String convertNameFromDb(String dbName, Grain g) {
        String name;
        if (g.getScore().getIdentifierParser() instanceof AnsiQuotedIdentifierParser) {
            name = dbName.substring(g.getName().length() + 1);
        } else {
            Matcher m = TABLE_PATTERN.matcher(dbName);
            if (!m.find()) {
                return null;
            }
            name = m.group(2);
        }
        return name;
    }

    @Override
    public String sequenceString(String schemaName, String sequenceName) {
        return this.sequenceString(schemaName, sequenceName, true);
    }

    private String sequenceString(String schemaName, String sequenceName, boolean isQuoted) {
        StringBuilder sb = new StringBuilder(NamedElement.limitName(FirebirdAdaptor.getSchemaUnderscoreNameTemplate(schemaName, sequenceName)));
        if (isQuoted) {
            sb.insert(0, '\"').append('\"');
        }
        return sb.toString();
    }

    private static /* synthetic */ boolean lambda$getCurrentIdent$2(IntegerColumn ic) {
        return ic.getSequence() != null;
    }

    private static /* synthetic */ IntegerColumn lambda$getCurrentIdent$1(Column c) {
        return (IntegerColumn)c;
    }

    private static /* synthetic */ boolean lambda$getCurrentIdent$0(Column c) {
        return c instanceof IntegerColumn;
    }
}

