/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.MsSqlColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DecimalColumn;

class MsSqlDecimalColumnDefiner
extends MsSqlColumnDefiner {
    MsSqlDecimalColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "decimal";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        DecimalColumn dc = (DecimalColumn)c;
        String fieldType = String.format("%s(%s,%s)", this.dbFieldType(), dc.getPrecision(), dc.getScale());
        return MsSqlDecimalColumnDefiner.join(c.getQuotedName(), fieldType, this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        DecimalColumn dc = (DecimalColumn)c;
        String defaultStr = "";
        if (dc.getDefaultValue() != null) {
            defaultStr = this.msSQLDefault(c) + dc.getDefaultValue();
        }
        return defaultStr;
    }

    @Override
    public String getLightDefaultDefinition(Column<?> c) {
        DecimalColumn dc = (DecimalColumn)c;
        String defaultStr = "";
        if (dc.getDefaultValue() != null) {
            defaultStr = "default " + dc.getDefaultValue();
        }
        return defaultStr;
    }
}

