/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.OraColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DecimalColumn;

class OraDecimalColumnDefiner
extends OraColumnDefiner {
    OraDecimalColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "NUMBER";
    }

    @Override
    public String getInternalDefinition(Column<?> c) {
        DecimalColumn dc = (DecimalColumn)c;
        String fieldType = String.format("%s(%s,%s)", this.dbFieldType(), dc.getPrecision(), dc.getScale());
        return OraDecimalColumnDefiner.join(c.getQuotedName(), fieldType);
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        DecimalColumn dc = (DecimalColumn)c;
        String defaultStr = "";
        if (dc.getDefaultValue() != null) {
            defaultStr = "default " + dc.getDefaultValue();
        }
        return defaultStr;
    }
}

