/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.ddl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefinerFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.function.CommonFunctions;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.Parameter;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.Sum;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.VersionedElement;

public final class MsSqlDdlGenerator
extends DdlGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MsSqlDdlGenerator.class);

    public MsSqlDdlGenerator(DBAdaptor dmlAdaptor) {
        super(dmlAdaptor);
    }

    @Override
    List<String> dropParameterizedView(String schemaName, String viewName, Connection conn) {
        String sql = String.format("DROP FUNCTION %s", this.tableString(schemaName, viewName));
        return Arrays.asList(sql);
    }

    @Override
    List<String> dropIndex(Grain g, DbIndexInfo dBIndexInfo) {
        String sql = String.format("DROP INDEX %s ON %s", dBIndexInfo.getIndexName(), this.tableString(g.getName(), dBIndexInfo.getTableName()));
        return Arrays.asList(sql);
    }

    @Override
    String dropTriggerSql(TriggerQuery query) {
        String sql = String.format("drop trigger %s", this.tableString(query.getSchema(), query.getName()));
        return sql;
    }

    @Override
    DBType getType() {
        return DBType.MSSQL;
    }

    @Override
    List<String> updateVersioningTrigger(Connection conn, TableElement t) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName()).withName(t.getName() + "_upd");
            boolean triggerExists = this.triggerExists(conn, query);
            if (t instanceof VersionedElement) {
                VersionedElement ve = (VersionedElement)((Object)t);
                if (ve.isVersioned()) {
                    if (!triggerExists) {
                        result.add(this.createVersioningTrigger(t));
                        this.rememberTrigger(query);
                    }
                } else if (triggerExists) {
                    result.add(this.dropTrigger(query));
                }
            }
        }
        catch (CelestaException e) {
            throw new CelestaException("Could not update version check trigger on %s.%s: %s", t.getGrain().getName(), t.getName(), e.getMessage());
        }
        return result;
    }

    private String createVersioningTrigger(TableElement t) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("create trigger \"%s\".\"%s_upd\" on \"%s\".\"%s\" for update as begin%n", t.getGrain().getName(), t.getName(), t.getGrain().getName(), t.getName()));
        sb.append(this.generateTsqlForVersioningTrigger(t));
        sb.append("end\n");
        LOGGER.trace("{}", (Object)sb);
        return sb.toString();
    }

    @Override
    public String dropPk(TableElement t, String pkName) {
        String sql = String.format("alter table %s.%s drop constraint \"%s\"", t.getGrain().getQuotedName(), t.getQuotedName(), pkName);
        return sql;
    }

    private String generateTsqlForVersioningTrigger(TableElement t) {
        StringBuilder sb = new StringBuilder();
        sb.append("IF  exists (select * from inserted inner join deleted on \n");
        this.addPKJoin(sb, "inserted", "deleted", t);
        sb.append("where inserted.recversion <> deleted.recversion) BEGIN\n");
        sb.append("  RAISERROR ('record version check failure', 16, 1);\n");
        sb.append("END\n");
        sb.append(String.format("update \"%s\".\"%s\" set recversion = recversion + 1 where%n", t.getGrain().getName(), t.getName()));
        sb.append("exists (select * from inserted where \n");
        this.addPKJoin(sb, "inserted", String.format("\"%s\".\"%s\"", t.getGrain().getName(), t.getName()), t);
        sb.append(");\n");
        return sb.toString();
    }

    private void addPKJoin(StringBuilder sb, String left, String right, TableElement t) {
        boolean needAnd = false;
        for (String s : t.getPrimaryKey().keySet()) {
            if (needAnd) {
                sb.append(" AND ");
            }
            sb.append(String.format("  %s.\"%s\" = %s.\"%s\"%n", left, s, right, s));
            needAnd = true;
        }
    }

    @Override
    List<String> updateColumn(Connection conn, Column<?> c, DbColumnInfo actual) {
        String sql;
        Class<?> cClass = c.getClass();
        ArrayList<String> result = new ArrayList<String>();
        if (!"".equals(actual.getDefaultValue())) {
            sql = String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " drop constraint \"def_%s_%s\"", c.getParentTable().getName(), c.getName());
            result.add(sql);
        }
        String def = ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass).getMainDefinition(c);
        sql = String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " alter column %s", def);
        result.add(sql);
        def = ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass).getDefaultDefinition(c);
        if (!"".equals(def)) {
            sql = String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " add %s for %s", def, c.getQuotedName());
            result.add(sql);
        }
        return result;
    }

    @Override
    List<String> createIndex(Index index) {
        String fieldList = CommonFunctions.getFieldList(index.getColumns().keySet());
        String sql = String.format("CREATE INDEX %s ON " + this.tableString(index.getTable().getGrain().getName(), index.getTable().getName()) + " (%s)", index.getQuotedName(), fieldList);
        return Arrays.asList(sql);
    }

    @Override
    public SQLGenerator getViewSQLGenerator() {
        return new SQLGenerator(){

            @Override
            protected String concat() {
                return " + ";
            }

            @Override
            protected String preamble(AbstractView view) {
                return String.format("create view %s as", this.viewName(view));
            }

            @Override
            protected String boolLiteral(boolean val) {
                return val ? "1" : "0";
            }

            @Override
            protected String paramLiteral(String paramName) {
                return "@" + paramName;
            }
        };
    }

    @Override
    List<String> createParameterizedView(ParameterizedView pv) {
        SQLGenerator gen = this.getViewSQLGenerator();
        StringWriter sw = new StringWriter();
        PrintWriter bw = new PrintWriter(sw);
        try {
            pv.selectScript(bw, gen);
        }
        catch (IOException e2) {
            throw new CelestaException(e2);
        }
        bw.flush();
        String inParams = pv.getParameters().entrySet().stream().map(e -> "@" + (String)e.getKey() + " " + ColumnDefinerFactory.getColumnDefiner(this.getType(), (Class)CELESTA_TYPES_COLUMN_CLASSES.get(((Parameter)e.getValue()).getType().getCelestaType())).dbFieldType()).collect(Collectors.joining(", "));
        String selectSql = sw.toString();
        String sql = String.format("CREATE FUNCTION " + this.tableString(pv.getGrain().getName(), pv.getName()) + "(%s)%n  RETURNS TABLE%n  AS%n  RETURN %s", inParams, selectSql);
        return Arrays.asList(sql);
    }

    @Override
    Optional<String> dropAutoIncrement(Connection conn, TableElement t) {
        String sql = String.format("delete from " + t.getGrain().getScore().getSysSchemaName() + ".sequences where grainid = '%s' and tablename = '%s';%n", t.getGrain().getName(), t.getName());
        return Optional.of(sql);
    }

    @Override
    String truncDate(String dateStr) {
        return "cast(floor(cast(" + dateStr + " as float)) as datetime)";
    }

    @Override
    public List<String> dropTableTriggersForMaterializedViews(Connection conn, BasicTable t) {
        ArrayList<String> result = new ArrayList<String>();
        List mvList = t.getGrain().getElements(MaterializedView.class).values().stream().filter(mv -> mv.getRefTable().getTable().equals(t)).collect(Collectors.toList());
        TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName());
        for (MaterializedView mv2 : mvList) {
            String insertTriggerName = mv2.getTriggerName(TriggerType.POST_INSERT);
            String deleteTriggerName = mv2.getTriggerName(TriggerType.POST_DELETE);
            query.withName(insertTriggerName);
            if (this.triggerExists(conn, query)) {
                result.add(this.dropTrigger(query));
            }
            query.withName(deleteTriggerName);
            if (!this.triggerExists(conn, query)) continue;
            result.add(this.dropTrigger(query));
        }
        if (!mvList.isEmpty()) {
            query.withName(t.getName() + "_upd");
            if (this.triggerExists(conn, query)) {
                result.add(this.dropTrigger(query));
            }
            if (t instanceof VersionedElement && ((VersionedElement)((Object)t)).isVersioned()) {
                result.add(this.createVersioningTrigger(t));
                this.rememberTrigger(query);
            }
        }
        return result;
    }

    @Override
    public List<String> createTableTriggersForMaterializedViews(BasicTable t) {
        ArrayList<String> result = new ArrayList<String>();
        String fullTableName = this.tableString(t.getGrain().getName(), t.getName());
        List mvList = t.getGrain().getElements(MaterializedView.class).values().stream().filter(mv -> mv.getRefTable().getTable().equals(t)).collect(Collectors.toList());
        if (mvList.isEmpty()) {
            return result;
        }
        StringBuilder afterUpdateTriggerTsql = new StringBuilder();
        if (t instanceof VersionedElement && ((VersionedElement)((Object)t)).isVersioned()) {
            afterUpdateTriggerTsql.append(this.generateTsqlForVersioningTrigger(t)).append("\n");
        }
        TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName());
        for (MaterializedView mv2 : mvList) {
            String fullMvName = this.tableString(mv2.getGrain().getName(), mv2.getName());
            String insertTriggerName = mv2.getTriggerName(TriggerType.POST_INSERT);
            String deleteTriggerName = mv2.getTriggerName(TriggerType.POST_DELETE);
            String mvColumns = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).collect(Collectors.joining(", ")).concat(", surrogate_count");
            String aggregateColumns = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> "aggregate." + alias).collect(Collectors.joining(", ")).concat(", surrogate_count");
            String rowConditionTemplate = mv2.getColumns().keySet().stream().filter(alias -> mv2.isGroupByColumn((String)alias)).map(alias -> "mv." + alias + " = %1$s." + alias + " ").collect(Collectors.joining(" AND "));
            String rowConditionForExistsTemplate = mv2.getColumns().keySet().stream().filter(alias -> mv2.isGroupByColumn((String)alias)).map(alias -> {
                Column<?> colRef = mv2.getColumnRef((String)alias);
                if ("DATETIME".equals(colRef.getCelestaType())) {
                    return "mv." + alias + " = cast(floor(cast(%1$s." + mv2.getColumnRef((String)alias).getName() + " as float)) as datetime)";
                }
                return "mv." + alias + " = %1$s." + mv2.getColumnRef((String)alias).getName() + " ";
            }).collect(Collectors.joining(" AND "));
            String setStatementTemplate = mv2.getAggregateColumns().entrySet().stream().map(e -> {
                StringBuilder sb = new StringBuilder();
                String alias = (String)e.getKey();
                sb.append("mv.").append(alias).append(" = mv.").append(alias).append(" %1$s aggregate.").append(alias);
                return sb.toString();
            }).collect(Collectors.joining(", ")).concat(", mv.").concat("surrogate_count").concat(" = ").concat("mv.").concat("surrogate_count").concat(" %1$s aggregate.").concat("surrogate_count");
            String tableGroupByColumns = mv2.getColumns().values().stream().filter(v -> mv2.isGroupByColumn(v.getName())).map(v -> {
                if ("DATETIME".equals(v.getCelestaType())) {
                    return "cast(floor(cast(\"" + v.getName() + "\" as float)) as datetime)";
                }
                return "\"" + mv2.getColumnRef(v.getName()).getName() + "\"";
            }).collect(Collectors.joining(", "));
            String selectPartOfScript = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> {
                Column<?> colRef = mv2.getColumnRef((String)alias);
                Map<String, Expr> aggrCols = mv2.getAggregateColumns();
                if (aggrCols.containsKey(alias)) {
                    if (colRef == null) {
                        if (aggrCols.get(alias) instanceof Count) {
                            return "COUNT(*) as \"" + alias + "\"";
                        }
                        return "";
                    }
                    if (aggrCols.get(alias) instanceof Sum) {
                        return "SUM(\"" + colRef.getName() + "\") as \"" + alias + "\"";
                    }
                    return "";
                }
                if ("DATETIME".equals(colRef.getCelestaType())) {
                    return "cast(floor(cast(\"" + colRef.getName() + "\" as float)) as datetime) as \"" + alias + "\"";
                }
                return "\"" + colRef.getName() + "\" as \"" + alias + "\"";
            }).filter(str -> !str.isEmpty()).collect(Collectors.joining(", ")).concat(", COUNT(*) AS surrogate_count");
            StringBuilder insertSqlBuilder = new StringBuilder("MERGE INTO %s WITH (HOLDLOCK) AS mv \n").append("USING (SELECT %s FROM inserted GROUP BY %s) AS aggregate ON %s \n").append("WHEN MATCHED THEN \n ").append("UPDATE SET %s \n").append("WHEN NOT MATCHED THEN \n").append("INSERT (%s) VALUES (%s); \n");
            String insertSql = String.format(insertSqlBuilder.toString(), fullMvName, selectPartOfScript, tableGroupByColumns, String.format(rowConditionTemplate, "aggregate"), String.format(setStatementTemplate, "+"), mvColumns, aggregateColumns);
            String deleteMatchedCondTemplate = mv2.getAggregateColumns().keySet().stream().map(alias -> "mv." + alias + " %1$s aggregate." + alias).collect(Collectors.joining(" %2$s "));
            String existsSql = "EXISTS(SELECT * FROM " + fullTableName + " AS t WHERE " + String.format(rowConditionForExistsTemplate, "t") + ")";
            StringBuilder deleteSqlBuilder = new StringBuilder("MERGE INTO %s WITH (HOLDLOCK) AS mv \n").append("USING (SELECT %s FROM deleted GROUP BY %s) AS aggregate ON %s \n").append("WHEN MATCHED AND %s THEN DELETE\n ").append("WHEN MATCHED AND (%s) THEN \n").append("UPDATE SET %s; \n");
            String deleteSql = String.format(deleteSqlBuilder.toString(), fullMvName, selectPartOfScript, tableGroupByColumns, String.format(rowConditionTemplate, "aggregate"), String.format(deleteMatchedCondTemplate, "=", "AND").concat(" AND NOT " + existsSql), String.format(deleteMatchedCondTemplate, "<>", "OR").concat(" OR (" + String.format(deleteMatchedCondTemplate, "=", "AND").concat(" AND " + existsSql + ")")), String.format(setStatementTemplate, "-"));
            String sql = String.format("create trigger \"%s\".\"%s\" on %s after insert as begin %n/*CHECKSUM%sCHECKSUM*/%n %s %n END;", t.getGrain().getName(), insertTriggerName, fullTableName, mv2.getChecksum(), insertSql);
            LOGGER.trace(sql);
            result.add(sql);
            this.rememberTrigger(query.withName(insertTriggerName));
            afterUpdateTriggerTsql.append(String.format("%n%s%n %n%s%n", deleteSql, insertSql));
            sql = String.format("create trigger \"%s\".\"%s\" on %s after delete as begin %n %s %n END;", t.getGrain().getName(), deleteTriggerName, fullTableName, deleteSql);
            LOGGER.trace(sql);
            result.add(sql);
            this.rememberTrigger(query.withName(deleteTriggerName));
        }
        StringBuilder sb = new StringBuilder();
        String sqlPrefix = t instanceof VersionedElement && ((VersionedElement)((Object)t)).isVersioned() ? "alter" : "create";
        String updateTriggerName = String.format("%s_upd", t.getName());
        sb.append(String.format("%s trigger \"%s\".\"%s\" on \"%s\".\"%s\" for update as begin%n", sqlPrefix, t.getGrain().getName(), updateTriggerName, t.getGrain().getName(), t.getName()));
        sb.append(afterUpdateTriggerTsql.toString());
        sb.append("end\n");
        result.add(sb.toString());
        this.rememberTrigger(query.withName(updateTriggerName));
        return result;
    }
}

