/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.stmt;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;

public abstract class PreparedStmtHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreparedStmtHolder.class);
    private PreparedStatement stmt;
    private final List<ParameterSetter> program = new LinkedList<ParameterSetter>();

    public boolean isStmtValid() {
        try {
            return this.stmt != null && !this.stmt.isClosed();
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    public synchronized PreparedStatement getStatement(Object[] rec, int recversion) {
        if (!this.isStmtValid()) {
            this.program.clear();
            this.stmt = this.initStatement(this.program);
            if (!this.isStmtValid()) {
                throw new IllegalStateException();
            }
        }
        int i = 1;
        for (ParameterSetter f : this.program) {
            f.execute(this.stmt, i++, rec, recversion);
        }
        LOGGER.trace("{}", (Object)this.stmt);
        return this.stmt;
    }

    public synchronized void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException e) {
            Object var1_2 = null;
        }
        this.stmt = null;
        this.program.clear();
    }

    protected abstract PreparedStatement initStatement(List<ParameterSetter> var1);
}

