/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.ParseException;

public abstract class NamedElementHolder<T extends NamedElement>
implements Collection<T> {
    private final LinkedHashMap<String, T> namespace = new LinkedHashMap();
    private final Map<String, T> namespaceReadOnly = Collections.unmodifiableMap(this.namespace);

    public Map<String, T> getElements() {
        return this.namespaceReadOnly;
    }

    protected abstract String getErrorMsg(String var1);

    public final void addElement(T element) throws ParseException {
        NamedElement oldValue = (NamedElement)this.namespace.put(((NamedElement)element).getName(), element);
        if (oldValue != null) {
            this.namespace.put(oldValue.getName(), oldValue);
            throw new ParseException(this.getErrorMsg(((NamedElement)element).getName()));
        }
    }

    public final T get(String name) {
        return (T)((NamedElement)this.namespace.get(name));
    }

    public final int getIndex(String name) {
        int i = -1;
        for (String c : this.namespace.keySet()) {
            ++i;
            if (!c.equals(name)) continue;
            return i;
        }
        return i;
    }

    @Override
    public final boolean isEmpty() {
        return this.namespace.isEmpty();
    }

    @Override
    public final Iterator<T> iterator() {
        return this.namespace.values().iterator();
    }

    @Override
    public final int size() {
        return this.namespace.size();
    }

    @Override
    public final boolean contains(Object o) {
        return this.namespace.containsValue(o);
    }

    @Override
    public final Object[] toArray() {
        return this.namespace.values().toArray();
    }

    @Override
    public final <A> A[] toArray(A[] a) {
        return this.namespace.values().toArray(a);
    }

    @Override
    @Deprecated
    public final boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object o) {
        if (o instanceof NamedElement) {
            NamedElement e = (NamedElement)o;
            return this.namespace.remove(e.getName()) != null;
        }
        return false;
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        this.namespace.clear();
    }
}

