/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.ViewColumnType;

public final class ViewColumnMeta<V>
implements ColumnMeta<V> {
    private static final Pattern COMMENT = Pattern.compile("/\\*\\*(.*)\\*/", 32);
    private final ViewColumnType type;
    private String name;
    private String celestaDoc = "";
    private boolean nullable = true;
    private final int length;

    public ViewColumnMeta(ViewColumnType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.length = -1;
    }

    public ViewColumnMeta(ViewColumnType type, int length) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.length = length;
    }

    public ViewColumnType getColumnType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String jdbcGetterName() {
        return this.type.jdbcGetterName();
    }

    @Override
    public String getCelestaType() {
        return this.type.getCelestaType();
    }

    @Override
    public Class<?> getJavaClass() {
        return this.type.getJavaClass();
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public String getCelestaDoc() {
        return this.celestaDoc;
    }

    void setName(String name) {
        this.name = name;
    }

    void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    void setCelestaDocLexem(String celestaDoc) throws ParseException {
        if (celestaDoc == null) {
            this.celestaDoc = null;
        } else {
            Matcher m = COMMENT.matcher(celestaDoc);
            if (!m.matches()) {
                throw new ParseException("Celestadoc should match pattern /**...*/, was " + celestaDoc);
            }
            this.celestaDoc = m.group(1);
        }
    }

    void setCelestaDoc(String celestaDoc) {
        this.celestaDoc = celestaDoc;
    }

    public int getLength() {
        return this.length;
    }
}

