/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.sql.Connection;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.ICallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.SystemCallContext;
import ru.curs.celesta.dbutils.DbUpdater;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.TableType;
import ru.curs.celesta.score.View;
import ru.curs.celesta.syscursors.GrainsCursor;
import ru.curs.celesta.syscursors.RolesCursor;
import ru.curs.celesta.syscursors.TablesCursor;
import ru.curs.celesta.syscursors.UserrolesCursor;

public final class DbUpdaterImpl
extends DbUpdater<CallContext> {
    static final String EXEC_NATIVE_NOT_SUPPORTED_MESSAGE = "\"EXECUTE NATIVE\" expression is not supported";
    private final ICelesta celesta;
    private TablesCursor table;

    public DbUpdaterImpl(ConnectionPool connectionPool, Score score, boolean forceDdInitialize, DBAdaptor dba, ICelesta celesta) {
        super(connectionPool, (AbstractScore)score, forceDdInitialize, dba);
        this.celesta = celesta;
    }

    protected void initDataAccessors(CallContext context) {
        this.schemaCursor = new GrainsCursor(context);
        this.table = new TablesCursor(context);
    }

    protected String getSchemasTableName() {
        return "grains";
    }

    protected CallContext createContext() {
        return new SystemCallContext(this.celesta);
    }

    public void updateSysGrain() {
        try (CallContext context = this.createContext();){
            this.schemaCursor = new GrainsCursor(context);
            this.table = new TablesCursor(context);
            this.updateSysGrain(context);
        }
    }

    public void updateSysGrain(CallContext context) {
        super.updateSysGrain((ICallContext)context);
        this.initSecurity(context);
    }

    void createSysObjects(Connection conn, Grain sys) throws ParseException {
        super.createSysObjects(conn, sys);
        this.dbAdaptor.createTable(conn, (TableElement)sys.getElement("tables", BasicTable.class));
        this.dbAdaptor.createTable(conn, (TableElement)sys.getElement("sequences", BasicTable.class));
        this.dbAdaptor.createTable(conn, (TableElement)sys.getElement("logsetup", BasicTable.class));
    }

    private void initSecurity(CallContext context) {
        RolesCursor roles = new RolesCursor(context);
        roles.clear();
        roles.setId("editor").setDescription("full read-write access").tryInsert();
        roles.clear();
        roles.setId("reader").setDescription("full read-only access").tryInsert();
        UserrolesCursor userRoles = new UserrolesCursor(context);
        userRoles.clear();
        userRoles.setRoleid("editor").setUserid("super").tryInsert();
    }

    protected void processGrainMeta(Grain g) {
        this.table.setRange(this.table.COLUMNS.grainid(), g.getName());
        while (this.table.nextInSet()) {
            switch (TableType.getByAbbreviation((String)this.table.getTabletype())) {
                case TABLE: {
                    this.table.setOrphaned(!g.getElements(BasicTable.class).containsKey(this.table.getTablename()));
                    break;
                }
                case VIEW: {
                    this.table.setOrphaned(!g.getElements(View.class).containsKey(this.table.getTablename()));
                    break;
                }
                case MATERIALIZED_VIEW: {
                    this.table.setOrphaned(!g.getElements(MaterializedView.class).containsKey(this.table.getTablename()));
                    break;
                }
                case FUNCTION: {
                    this.table.setOrphaned(!g.getElements(ParameterizedView.class).containsKey(this.table.getTablename()));
                    break;
                }
            }
            this.table.update();
        }
        for (BasicTable t : g.getElements(BasicTable.class).values()) {
            this.table.setGrainid(g.getName());
            this.table.setTablename(t.getName());
            this.table.setTabletype(TableType.TABLE.getAbbreviation());
            this.table.setOrphaned(false);
            this.table.tryInsert();
        }
        for (View v : g.getElements(View.class).values()) {
            this.table.setGrainid(g.getName());
            this.table.setTablename(v.getName());
            this.table.setTabletype(TableType.VIEW.getAbbreviation());
            this.table.setOrphaned(false);
            this.table.tryInsert();
        }
        for (MaterializedView mv : g.getElements(MaterializedView.class).values()) {
            this.table.setGrainid(g.getName());
            this.table.setTablename(mv.getName());
            this.table.setTabletype(TableType.MATERIALIZED_VIEW.getAbbreviation());
            this.table.setOrphaned(false);
            this.table.tryInsert();
        }
        for (ParameterizedView pv : g.getElements(ParameterizedView.class).values()) {
            this.table.setGrainid(g.getName());
            this.table.setTablename(pv.getName());
            this.table.setTabletype(TableType.FUNCTION.getAbbreviation());
            this.table.setOrphaned(false);
            this.table.tryInsert();
        }
    }

    protected void beforeGrainUpdating(Grain g) {
        for (DBType dbType : DBType.values()) {
            if (g.getBeforeSqlList(dbType).isEmpty() && g.getAfterSqlList(dbType).isEmpty()) continue;
            throw new CelestaException(EXEC_NATIVE_NOT_SUPPORTED_MESSAGE);
        }
    }
}

