package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CelestaGenerated;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2021-02-18T14:15:45.503"
)
@CelestaGenerated
public final class CalllogCursor extends Cursor implements Iterable<CalllogCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "calllog";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final CalllogCursor.Columns COLUMNS;

    private Integer entryno;

    private String sessionid;

    private String userid;

    private String procname;

    private Date starttime;

    private Integer duration;

    {
        this.COLUMNS = new CalllogCursor.Columns(callContext().getCelesta());
    }

    public CalllogCursor(CallContext context) {
        super(context);
    }

    public CalllogCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public CalllogCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public Integer getEntryno() {
        return this.entryno;
    }

    public void setEntryno(Integer entryno) {
        this.entryno = entryno;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getProcname() {
        return this.procname;
    }

    public void setProcname(String procname) {
        this.procname = procname;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Date starttime) {
        this.starttime = starttime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[1];
        result[0] = this.entryno;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("entryno")) {
            this.entryno = rs.getInt("entryno");
            if (rs.wasNull()) {
                this.entryno = null;
            }
        }
        if (this.inRec("sessionid")) {
            this.sessionid = rs.getString("sessionid");
            if (rs.wasNull()) {
                this.sessionid = null;
            }
        }
        if (this.inRec("userid")) {
            this.userid = rs.getString("userid");
            if (rs.wasNull()) {
                this.userid = null;
            }
        }
        if (this.inRec("procname")) {
            this.procname = rs.getString("procname");
            if (rs.wasNull()) {
                this.procname = null;
            }
        }
        if (this.inRec("starttime")) {
            this.starttime = rs.getTimestamp("starttime");
            if (rs.wasNull()) {
                this.starttime = null;
            }
        }
        if (this.inRec("duration")) {
            this.duration = rs.getInt("duration");
            if (rs.wasNull()) {
                this.duration = null;
            }
        }
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.entryno = null;
        }
        this.sessionid = null;
        this.userid = null;
        this.procname = null;
        this.starttime = null;
        this.duration = null;
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[6];
        result[0] = this.entryno;
        result[1] = this.sessionid;
        result[2] = this.userid;
        result[3] = this.procname;
        result[4] = this.starttime;
        result[5] = this.duration;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
        this.entryno = val;
    }

    public static void onPreDelete(ICelesta celesta,
            Consumer<? super CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, CalllogCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, CalllogCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta,
            Consumer<? super CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, CalllogCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, CalllogCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta,
            Consumer<? super CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, CalllogCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super CalllogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, CalllogCursor.class, cursorConsumer);
    }

    @Override
    public CalllogCursor _getBufferCopy(CallContext context, List<String> fields) {
        final CalllogCursor result;
        if (Objects.isNull(fields)) {
            result = new CalllogCursor(context);
        }
        else {
            result = new CalllogCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        CalllogCursor from = (CalllogCursor)c;
        this.entryno = from.entryno;
        this.sessionid = from.sessionid;
        this.userid = from.userid;
        this.procname = from.procname;
        this.starttime = from.starttime;
        this.duration = from.duration;
    }

    @Override
    public Iterator<CalllogCursor> iterator() {
        return new CursorIterator<CalllogCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2021-02-18T14:15:45.504"
    )
    @CelestaGenerated
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<Integer> entryno() {
            return (ColumnMeta<Integer>) this.element.getColumns().get("entryno");
        }

        public ColumnMeta<String> sessionid() {
            return (ColumnMeta<String>) this.element.getColumns().get("sessionid");
        }

        public ColumnMeta<String> userid() {
            return (ColumnMeta<String>) this.element.getColumns().get("userid");
        }

        public ColumnMeta<String> procname() {
            return (ColumnMeta<String>) this.element.getColumns().get("procname");
        }

        public ColumnMeta<Date> starttime() {
            return (ColumnMeta<Date>) this.element.getColumns().get("starttime");
        }

        public ColumnMeta<Integer> duration() {
            return (ColumnMeta<Integer>) this.element.getColumns().get("duration");
        }
    }
}
