package testTable;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CelestaGenerated;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2021-02-18T14:15:45.817"
)
@CelestaGenerated
public final class TCopyFieldsCursor extends Cursor implements Iterable<TCopyFieldsCursor> {
    private static final String GRAIN_NAME = "testTable";

    private static final String OBJECT_NAME = "tCopyFields";

    public final TCopyFieldsCursor.Columns COLUMNS;

    private Integer id;

    private String title;

    {
        this.COLUMNS = new TCopyFieldsCursor.Columns(callContext().getCelesta());
    }

    public TCopyFieldsCursor(CallContext context) {
        super(context);
    }

    public TCopyFieldsCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public TCopyFieldsCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        Object[] result = new Object[1];
        result[0] = this.id;
        return result;
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("id")) {
            this.id = rs.getInt("id");
            if (rs.wasNull()) {
                this.id = null;
            }
        }
        if (this.inRec("title")) {
            this.title = rs.getString("title");
            if (rs.wasNull()) {
                this.title = null;
            }
        }
        this.setRecversion(rs.getInt("recversion"));
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.id = null;
        }
        this.title = null;
    }

    @Override
    public Object[] _currentValues() {
        Object[] result = new Object[2];
        result[0] = this.id;
        result[1] = this.title;
        return result;
    }

    @Override
    protected void _setAutoIncrement(int val) {
        this.id = val;
    }

    public static void onPreDelete(ICelesta celesta,
            Consumer<? super TCopyFieldsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, TCopyFieldsCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super TCopyFieldsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, TCopyFieldsCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta,
            Consumer<? super TCopyFieldsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, TCopyFieldsCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super TCopyFieldsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, TCopyFieldsCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta,
            Consumer<? super TCopyFieldsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, TCopyFieldsCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super TCopyFieldsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, TCopyFieldsCursor.class, cursorConsumer);
    }

    @Override
    public TCopyFieldsCursor _getBufferCopy(CallContext context, List<String> fields) {
        final TCopyFieldsCursor result;
        if (Objects.isNull(fields)) {
            result = new TCopyFieldsCursor(context);
        }
        else {
            result = new TCopyFieldsCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        TCopyFieldsCursor from = (TCopyFieldsCursor)c;
        this.id = from.id;
        this.title = from.title;
        this.setRecversion(from.getRecversion());
    }

    @Override
    public Iterator<TCopyFieldsCursor> iterator() {
        return new CursorIterator<TCopyFieldsCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2021-02-18T14:15:45.818"
    )
    @CelestaGenerated
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<Integer> id() {
            return (ColumnMeta<Integer>) this.element.getColumns().get("id");
        }

        public ColumnMeta<String> title() {
            return (ColumnMeta<String>) this.element.getColumns().get("title");
        }
    }
}
