/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.ConnectionPoolConfiguration;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.test.common.AdvancedFireBirdContainer;
import ru.curs.celesta.test.common.CollatedMSSQLServerContainer;

public class ContainerUtils {
    public static final PostgreSQLContainer POSTGRE_SQL = new PostgreSQLContainer();
    public static final OracleContainer ORACLE = new OracleContainer();
    public static final CollatedMSSQLServerContainer MSSQL = new CollatedMSSQLServerContainer().withCollation("Cyrillic_General_CI_AI");
    public static final AdvancedFireBirdContainer FIREBIRD = new AdvancedFireBirdContainer();
    private static final String DROP_TABLE_FROM_ORACLE_TEMPLATE = "DROP TABLE %s CASCADE CONSTRAINTS";
    private static final String DROP_OBJECT_FROM_ORACLE_TEMPLATE = "DROP %s %s";
    private static final String DROP_TYPE_FROM_ORACLE_TEMPLATE = "DROP TYPE %s FORCE";
    private static final Map<Class<? extends JdbcDatabaseContainer>, Runnable> CLEAN_UP_MAP = new HashMap<Class<? extends JdbcDatabaseContainer>, Runnable>();

    public static void cleanUp(JdbcDatabaseContainer container) {
        CLEAN_UP_MAP.get(container.getClass()).run();
    }

    private static void cleanUpPostgres() {
        try (ConnectionPool connectionPool = ContainerUtils.getConnectionPool((JdbcDatabaseContainer)POSTGRE_SQL);
             Connection connection = connectionPool.get();){
            try (ResultSet rs = SqlUtils.executeQuery((Connection)connection, (String)"select distinct schemaname          from pg_catalog.pg_tables                   where schemaname not in ('pg_catalog', 'information_schema') ");){
                while (rs.next()) {
                    SqlUtils.executeUpdate((Connection)connection, (String)String.format("DROP SCHEMA IF EXISTS \"%s\" CASCADE", rs.getString(1)));
                }
            }
            connection.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void cleanUpOracle() {
        block45: {
            try {
                connectionPool = ContainerUtils.getConnectionPool((JdbcDatabaseContainer)ContainerUtils.ORACLE);
                var1_2 = null;
                try {
                    connection = connectionPool.get();
                    var3_6 = null;
                    try {
                        rs = SqlUtils.executeQuery((Connection)connection, (String)"SELECT object_name, object_type\n                     FROM user_objects\n                    WHERE object_type IN\n                             ('TABLE',\n                              'VIEW',\n                              'MATERIALIZED VIEW',\n                              'PACKAGE',\n                              'PROCEDURE',\n                              'FUNCTION',\n                              'TYPE',\n                              'SEQUENCE',\n                              'SYNONYM',\n                              'PACKAGE BODY'\n                             )                    AND created > sysdate - interval '1' hour");
                        var5_10 = null;
lbl10:
                        // 3 sources

                        while (true) {
                            ** try [egrp 3[TRYBLOCK] [2, 3 : 27->254)] { 
lbl12:
                            // 1 sources

                            break;
lbl13:
                            // 1 sources

                            catch (Throwable var6_14) {
                                var5_10 = var6_14;
                                throw var6_14;
                            }
                            break;
                        }
                    }
                    catch (Throwable var4_9) {
                        var3_6 = var4_9;
                        throw var4_9;
                    }
                }
                catch (Throwable var2_5) {
                    var1_2 = var2_5;
                    throw var2_5;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            while (rs.next()) {
                try {
                    block44: {
                        objectType = rs.getString("object_type");
                        objectName = rs.getString("object_name");
                        if (!"TABLE".equalsIgnoreCase(objectType)) break block44;
                        SqlUtils.executeUpdate((Connection)connection, (String)String.format("DROP TABLE %s CASCADE CONSTRAINTS", new Object[]{String.format("\"%s\"", new Object[]{objectName})}));
                        ** GOTO lbl10
                    }
                    if ("TYPE".equalsIgnoreCase(objectType)) {
                        SqlUtils.executeUpdate((Connection)connection, (String)String.format("DROP TYPE %s FORCE", new Object[]{String.format("\"%s\"", new Object[]{objectName})}));
                        ** continue;
                    }
                    SqlUtils.executeUpdate((Connection)connection, (String)String.format("DROP %s %s", new Object[]{objectType, String.format("\"%s\"", new Object[]{objectName})}));
                }
                catch (CelestaException e) {
                    sqlException = (SQLException)e.getCause();
                    if (Arrays.asList(new Integer[]{942, 2289, 4043}).contains(sqlException.getErrorCode()) == false) throw e;
                }
            }
            break block45;
lbl46:
            // 1 sources

            finally {
                if (rs != null) {
                    if (var5_10 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable var6_13) {
                            var5_10.addSuppressed(var6_13);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        connection.commit();
        return;
        finally {
            if (connection != null) {
                if (var3_6 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable var4_8) {
                        var3_6.addSuppressed(var4_8);
                    }
                } else {
                    connection.close();
                }
            }
        }
        finally {
            if (connectionPool != null) {
                if (var1_2 != null) {
                    try {
                        connectionPool.close();
                    }
                    catch (Throwable var2_4) {
                        var1_2.addSuppressed(var2_4);
                    }
                } else {
                    connectionPool.close();
                }
            }
        }
    }

    private static void cleanUpMsSql() {
        ConnectionPoolConfiguration connectionPoolConfiguration = ContainerUtils.connectionPoolConfiguration((JdbcDatabaseContainer)MSSQL);
        connectionPoolConfiguration.setJdbcConnectionUrl(MSSQL.getInitJdbcUrl());
        try (ConnectionPool connectionPool = ConnectionPool.create((ConnectionPoolConfiguration)connectionPoolConfiguration);
             Connection connection = connectionPool.get();){
            SqlUtils.executeUpdate((Connection)connection, (String)String.format("DROP DATABASE IF EXISTS %s", "celesta"));
            connection.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void cleanUpFirebird() {
        FIREBIRD.dropDb();
    }

    private static ConnectionPool getConnectionPool(JdbcDatabaseContainer container) {
        ConnectionPoolConfiguration poolConfiguration = ContainerUtils.connectionPoolConfiguration(container);
        return ConnectionPool.create((ConnectionPoolConfiguration)poolConfiguration);
    }

    private static ConnectionPoolConfiguration connectionPoolConfiguration(JdbcDatabaseContainer container) {
        ConnectionPoolConfiguration poolConfiguration = new ConnectionPoolConfiguration();
        poolConfiguration.setJdbcConnectionUrl(container.getJdbcUrl());
        poolConfiguration.setLogin(container.getUsername());
        poolConfiguration.setPassword(container.getPassword());
        poolConfiguration.setDriverClassName(container.getDriverClassName());
        return poolConfiguration;
    }

    static {
        CLEAN_UP_MAP.put(POSTGRE_SQL.getClass(), ContainerUtils::cleanUpPostgres);
        CLEAN_UP_MAP.put(ORACLE.getClass(), ContainerUtils::cleanUpOracle);
        CLEAN_UP_MAP.put(((Object)((Object)MSSQL)).getClass(), ContainerUtils::cleanUpMsSql);
        CLEAN_UP_MAP.put(((Object)((Object)FIREBIRD)).getClass(), ContainerUtils::cleanUpFirebird);
    }
}

