/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.transaction;

import java.util.Arrays;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;

@Aspect
public final class CelestaTransactionAspect {
    private final ICelesta celesta;

    public CelestaTransactionAspect(ICelesta celesta) {
        this.celesta = celesta;
    }

    @Around(value="@annotation(CelestaTransaction)")
    public Object execEntryPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Optional<CallContext> cc = Arrays.stream(joinPoint.getArgs()).filter(CallContext.class::isInstance).map(CallContext.class::cast).findFirst();
        if (cc.isPresent()) {
            return this.proceedInTransaction(cc.get(), joinPoint);
        }
        return joinPoint.proceed();
    }

    private Object proceedInTransaction(CallContext c, ProceedingJoinPoint joinPoint) throws Throwable {
        if (c.getDBPid() != 0) {
            return joinPoint.proceed();
        }
        try {
            c.activate(this.celesta, joinPoint.getSignature().toShortString());
            Object result = joinPoint.proceed();
            c.commit();
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            c.rollback();
            throw e;
        }
        finally {
            c.close();
        }
    }
}

