/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import ru.d_shap.cli.CliIOException;
import ru.d_shap.cli.Command;
import ru.d_shap.cli.data.Context;
import ru.d_shap.cli.io.InputStreamWrapper;
import ru.d_shap.cli.io.OutputStreamWrapper;

public final class CommandRunner {
    public static final String CHARSET_NAME = "UTF-8";
    private final PrintWriter _writer;
    private final BufferedReader _reader;

    public CommandRunner(OutputStream outputStream, InputStream inputStream) {
        this(outputStream, inputStream, null, CHARSET_NAME);
    }

    public CommandRunner(OutputStream outputStream, InputStream inputStream, OutputStream logOutputStream) {
        this(outputStream, inputStream, logOutputStream, CHARSET_NAME);
    }

    public CommandRunner(OutputStream outputStream, InputStream inputStream, String charsetName) {
        this(outputStream, inputStream, null, charsetName);
    }

    public CommandRunner(OutputStream outputStream, InputStream inputStream, OutputStream logOutputStream, String charsetName) {
        try {
            OutputStreamWrapper outputStreamWrapper = new OutputStreamWrapper(outputStream, logOutputStream);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStreamWrapper, charsetName);
            this._writer = new PrintWriter(writer);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream, logOutputStream);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStreamWrapper, charsetName);
            this._reader = new BufferedReader(reader);
        }
        catch (UnsupportedEncodingException ex) {
            throw new CliIOException(ex);
        }
    }

    public CommandRunner(OutputStream outputStream, InputStream inputStream, Charset charset) {
        this(outputStream, inputStream, null, charset.name());
    }

    public CommandRunner(OutputStream outputStream, InputStream inputStream, OutputStream logOutputStream, Charset charset) {
        this(outputStream, inputStream, logOutputStream, charset.name());
    }

    public PrintWriter getWriter() {
        return this._writer;
    }

    public BufferedReader getReader() {
        return this._reader;
    }

    public void execute(Command command) {
        this.execute(command, null);
    }

    public void execute(Command command, Context context) {
        Command currentCommand = command;
        Context currentContext = context == null ? new Context() : context;
        while (currentCommand != null) {
            currentCommand.setContext(currentContext);
            currentCommand.setCommandRunner(this);
            Command nextCommand = currentCommand.execute(this._writer, this._reader);
            if (nextCommand == null) {
                nextCommand = currentCommand.getParentCommand();
            }
            currentCommand = nextCommand;
        }
    }
}

