/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.command;

import java.util.ArrayList;
import java.util.List;
import ru.d_shap.cli.Command;
import ru.d_shap.cli.CommandRunner;
import ru.d_shap.cli.data.Context;
import ru.d_shap.cli.data.ValueHolder;
import ru.d_shap.cli.data.ValueLoader;

public abstract class AbstractCommand
implements Command {
    private final Command _parentCommand;
    private Context _context;
    private CommandRunner _commandRunner;
    private final List<ValueHolder<?>> _valueHolders;

    protected AbstractCommand() {
        this(null);
    }

    protected AbstractCommand(Command parentCommand) {
        this._parentCommand = parentCommand;
        this._context = null;
        this._commandRunner = null;
        this._valueHolders = new ArrayList();
    }

    @Override
    public final boolean hasParentCommand() {
        return this.getParentCommand() != null;
    }

    @Override
    public final <T extends Command> boolean hasParentCommand(Class<T> clazz) {
        return this.getParentCommand(clazz) != null;
    }

    @Override
    public final Command getParentCommand() {
        return this._parentCommand;
    }

    @Override
    public final <T extends Command> Command getParentCommand(Class<T> clazz) {
        Command parentCommand;
        for (parentCommand = this._parentCommand; parentCommand != null && !clazz.isInstance(parentCommand); parentCommand = parentCommand.getParentCommand()) {
        }
        return parentCommand;
    }

    @Override
    public final Context getContext() {
        return this._context;
    }

    @Override
    public final void setContext(Context context) {
        this._context = context;
    }

    @Override
    public final CommandRunner getCommandRunner() {
        return this._commandRunner;
    }

    @Override
    public final void setCommandRunner(CommandRunner commandRunner) {
        this._commandRunner = commandRunner;
    }

    protected final <T> ValueHolder<T> createValueHolder(ValueLoader<T> valueLoader) {
        ValueHolder<T> valueHolder = new ValueHolder<T>(valueLoader);
        this._valueHolders.add(valueHolder);
        return valueHolder;
    }

    @Override
    public final void reset() {
        for (ValueHolder<?> valueHolder : this._valueHolders) {
            valueHolder.reset();
        }
    }
}

