/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import ru.d_shap.cli.CliIOException;
import ru.d_shap.cli.Command;
import ru.d_shap.cli.command.AbstractCommand;
import ru.d_shap.cli.data.ValueHolder;

public abstract class AbstractUserActionCommand
extends AbstractCommand {
    protected AbstractUserActionCommand() {
        this(null);
    }

    protected AbstractUserActionCommand(Command parentCommand) {
        super(parentCommand);
    }

    @Override
    public final Command execute(PrintWriter writer, BufferedReader reader) {
        try {
            this.printMessage(writer);
            writer.flush();
            String input = reader.readLine();
            input = input == null ? "" : input.trim();
            Command command = this.isDefaultInput(input) ? this.processDefaultInput(input, writer) : this.processInput(input, writer);
            writer.println();
            writer.flush();
            return command;
        }
        catch (IOException ex) {
            throw new CliIOException(ex);
        }
    }

    protected abstract void printMessage(PrintWriter var1);

    protected final boolean isDefaultInput(String input) {
        return "".equals(input);
    }

    protected abstract Command processDefaultInput(String var1, PrintWriter var2);

    protected abstract Command processInput(String var1, PrintWriter var2);

    protected final Command processWrongInput(ValueHolder<String> wrongInputMessage, String input, PrintWriter writer) {
        String str = wrongInputMessage == null ? null : wrongInputMessage.getValue();
        return this.processWrongInput(str, input, writer);
    }

    protected final Command processWrongInput(String wrongInputMessage, String input, PrintWriter writer) {
        if (wrongInputMessage != null) {
            String str = String.format(wrongInputMessage, input);
            writer.println(str);
        }
        return this;
    }
}

