/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.command.input;

import java.util.HashSet;
import java.util.Set;
import ru.d_shap.cli.Command;
import ru.d_shap.cli.command.CommandDefinitionException;
import ru.d_shap.cli.command.input.AbstractInputCommand;
import ru.d_shap.cli.data.ValueHolder;
import ru.d_shap.cli.data.ValueLoader;

public abstract class AbstractInputBooleanCommand
extends AbstractInputCommand<Boolean> {
    private final ValueHolder<Set<String>> _trueValues = this.createValueHolder(new TrueValuesLoader());
    private final ValueHolder<Set<String>> _falseValues = this.createValueHolder(new FalseValuesLoader());

    protected AbstractInputBooleanCommand() {
        this(null);
    }

    protected AbstractInputBooleanCommand(Command parentCommand) {
        super(parentCommand);
    }

    protected abstract Set<String> getTrueValues();

    protected abstract Set<String> getFalseValues();

    @Override
    protected final boolean isValidType(String input) {
        Set<String> trueValues = this._trueValues.getValue();
        for (String trueValue : trueValues) {
            if (!trueValue.equalsIgnoreCase(input)) continue;
            return true;
        }
        Set<String> falseValues = this._falseValues.getValue();
        for (String falseValue : falseValues) {
            if (!falseValue.equalsIgnoreCase(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final Boolean getValue(String input) {
        Set<String> trueValues = this._trueValues.getValue();
        for (String trueValue : trueValues) {
            if (!trueValue.equalsIgnoreCase(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final String getValueAsString(Boolean value) {
        if (value.booleanValue()) {
            Set<String> trueValues = this._trueValues.getValue();
            return trueValues.iterator().next();
        }
        Set<String> falseValues = this._falseValues.getValue();
        return falseValues.iterator().next();
    }

    private final class FalseValuesLoader
    implements ValueLoader<Set<String>> {
        FalseValuesLoader() {
        }

        @Override
        public Set<String> loadValue() {
            Set<String> falseValues = AbstractInputBooleanCommand.this.getFalseValues();
            this.checkFalseValuesDefined(falseValues);
            return falseValues;
        }

        private void checkFalseValuesDefined(Set<String> falseValues) {
            if (falseValues == null || falseValues.isEmpty()) {
                throw new CommandDefinitionException("False values are not defined");
            }
        }
    }

    private final class TrueValuesLoader
    implements ValueLoader<Set<String>> {
        TrueValuesLoader() {
        }

        @Override
        public Set<String> loadValue() {
            Set<String> trueValues = AbstractInputBooleanCommand.this.getTrueValues();
            this.checkTrueValuesDefined(trueValues);
            this.checkSameValues(trueValues);
            return trueValues;
        }

        private void checkTrueValuesDefined(Set<String> trueValues) {
            if (trueValues == null || trueValues.isEmpty()) {
                throw new CommandDefinitionException("True values are not defined");
            }
        }

        private void checkSameValues(Set<String> trueValues) {
            Set falseValues = (Set)AbstractInputBooleanCommand.this._falseValues.getValue();
            HashSet<String> set = new HashSet<String>(trueValues);
            set.retainAll(falseValues);
            if (!set.isEmpty()) {
                throw new CommandDefinitionException("True values and False values contain the same value");
            }
        }
    }
}

