/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.command.input;

import java.io.PrintWriter;
import java.util.List;
import ru.d_shap.cli.Command;
import ru.d_shap.cli.command.AbstractUserActionCommand;
import ru.d_shap.cli.command.CommandDefinitionException;
import ru.d_shap.cli.data.Lines;
import ru.d_shap.cli.data.ValueHolder;
import ru.d_shap.cli.data.ValueLoader;

public abstract class AbstractInputCommand<T>
extends AbstractUserActionCommand {
    private final ValueHolder<String> _contextKey = this.createValueHolder(new ContextKeyLoader());
    private final ValueHolder<Lines> _header = this.createValueHolder(new HeaderLoader());
    private final ValueHolder<String> _defaultMessage = this.createValueHolder(new DefaultMessageLoader());
    private final ValueHolder<String> _wrongInputMessage = this.createValueHolder(new WrongInputMessageLoader());

    protected AbstractInputCommand() {
        this(null);
    }

    protected AbstractInputCommand(Command parentCommand) {
        super(parentCommand);
    }

    protected abstract String getContextKey();

    protected abstract Lines getHeader();

    protected abstract String getDefaultMessage();

    protected abstract String getWrongInputMessage();

    @Override
    protected final void printMessage(PrintWriter writer) {
        Object contextValue;
        Lines header = this._header.getValue();
        List<String> lines = header.getLines();
        for (String line : lines) {
            writer.println(line);
        }
        String contextKey = this._contextKey.getValue();
        boolean hasContextValue = this.getContext().hasValue(contextKey);
        String defaultMessage = this._defaultMessage.getValue();
        if (hasContextValue && defaultMessage != null && this.isValidValue(contextValue = this.getContext().getValue(contextKey))) {
            String stringValue = this.asString(contextValue);
            String str = String.format(defaultMessage, stringValue);
            writer.println(str);
        }
    }

    @Override
    protected final Command processDefaultInput(String input, PrintWriter writer) {
        Object contextValue;
        String contextKey = this._contextKey.getValue();
        boolean hasContextValue = this.getContext().hasValue(contextKey);
        if (hasContextValue && this.isValidValue(contextValue = this.getContext().getValue(contextKey))) {
            return this.processValue(contextValue, writer);
        }
        return this.processWrongInput(this._wrongInputMessage, input, writer);
    }

    @Override
    protected final Command processInput(String input, PrintWriter writer) {
        T value;
        if (this.isValidType(input) && this.isValidValue(value = this.getValue(input))) {
            String contextKey = this._contextKey.getValue();
            this.getContext().putValue(contextKey, value);
            return this.processValue(value, writer);
        }
        return this.processWrongInput(this._wrongInputMessage, input, writer);
    }

    protected abstract boolean isValidType(String var1);

    protected abstract T getValue(String var1);

    private String asString(T value) {
        if (value == null) {
            return "";
        }
        return this.getValueAsString(value);
    }

    protected abstract String getValueAsString(T var1);

    protected abstract boolean isValidValue(T var1);

    protected abstract Command processValue(T var1, PrintWriter var2);

    private final class WrongInputMessageLoader
    implements ValueLoader<String> {
        WrongInputMessageLoader() {
        }

        @Override
        public String loadValue() {
            return AbstractInputCommand.this.getWrongInputMessage();
        }
    }

    private final class DefaultMessageLoader
    implements ValueLoader<String> {
        DefaultMessageLoader() {
        }

        @Override
        public String loadValue() {
            return AbstractInputCommand.this.getDefaultMessage();
        }
    }

    private final class HeaderLoader
    implements ValueLoader<Lines> {
        HeaderLoader() {
        }

        @Override
        public Lines loadValue() {
            Lines header = AbstractInputCommand.this.getHeader();
            this.checkHeaderDefined(header);
            return header;
        }

        private void checkHeaderDefined(Lines header) {
            if (header == null) {
                throw new CommandDefinitionException("Header is not defined");
            }
        }
    }

    private final class ContextKeyLoader
    implements ValueLoader<String> {
        ContextKeyLoader() {
        }

        @Override
        public String loadValue() {
            return AbstractInputCommand.this.getContextKey();
        }
    }
}

