/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.command.menu;

import java.io.PrintWriter;
import java.util.List;
import ru.d_shap.cli.Command;
import ru.d_shap.cli.command.AbstractUserActionCommand;
import ru.d_shap.cli.command.CommandDefinitionException;
import ru.d_shap.cli.command.menu.Option;
import ru.d_shap.cli.command.menu.SelectableOption;
import ru.d_shap.cli.data.Lines;
import ru.d_shap.cli.data.ValueHolder;
import ru.d_shap.cli.data.ValueLoader;

public abstract class AbstractMenuCommand
extends AbstractUserActionCommand {
    public static final int DEFAULT_SYMBOL_LENGTH = 7;
    public static final int NO_DEFAULT_OPTION_INDEX = -1;
    private final ValueHolder<Lines> _header = this.createValueHolder(new HeaderLoader());
    private final ValueHolder<List<Option>> _options = this.createValueHolder(new OptionsLoader());
    private final ValueHolder<Integer> _symbolLength = this.createValueHolder(new SymbolLengthLoader());
    private final ValueHolder<Integer> _defaultOptionIndex = this.createValueHolder(new DefaultOptionIndexLoader());
    private final ValueHolder<String> _wrongInputMessage = this.createValueHolder(new WrongInputMessageLoader());

    protected AbstractMenuCommand() {
        this(null);
    }

    protected AbstractMenuCommand(Command parentCommand) {
        super(parentCommand);
    }

    protected abstract Lines getHeader();

    protected abstract List<Option> getOptions();

    protected abstract int getSymbolLength();

    protected abstract int getDefaultOptionIndex();

    protected abstract String getWrongInputMessage();

    @Override
    protected final void printMessage(PrintWriter writer) {
        Lines header = this._header.getValue();
        List<String> lines = header.getLines();
        for (String line : lines) {
            writer.println(line);
        }
        List<Option> options = this._options.getValue();
        int symbolLength = this._symbolLength.getValue();
        int defaultOptionIndex = this._defaultOptionIndex.getValue();
        for (int i = 0; i < options.size(); ++i) {
            Option option = options.get(i);
            option.print(writer, symbolLength, i == defaultOptionIndex);
        }
    }

    @Override
    protected final Command processDefaultInput(String input, PrintWriter writer) {
        List<Option> options = this._options.getValue();
        int defaultOptionIndex = this._defaultOptionIndex.getValue();
        if (defaultOptionIndex >= 0) {
            Option option = options.get(defaultOptionIndex);
            return ((SelectableOption)option).getCommand();
        }
        return this.processWrongInput(this._wrongInputMessage, input, writer);
    }

    @Override
    protected final Command processInput(String input, PrintWriter writer) {
        List<Option> options = this._options.getValue();
        for (Option option : options) {
            if (!(option instanceof SelectableOption) || !((SelectableOption)option).isSelected(input)) continue;
            return ((SelectableOption)option).getCommand();
        }
        return this.processWrongInput(this._wrongInputMessage, input, writer);
    }

    private final class WrongInputMessageLoader
    implements ValueLoader<String> {
        WrongInputMessageLoader() {
        }

        @Override
        public String loadValue() {
            return AbstractMenuCommand.this.getWrongInputMessage();
        }
    }

    private final class DefaultOptionIndexLoader
    implements ValueLoader<Integer> {
        DefaultOptionIndexLoader() {
        }

        @Override
        public Integer loadValue() {
            int defaultOptionIndex = AbstractMenuCommand.this.getDefaultOptionIndex();
            this.checkSelectableOption(defaultOptionIndex);
            return defaultOptionIndex;
        }

        private void checkSelectableOption(int defaultOptionIndex) {
            if (defaultOptionIndex < 0) {
                return;
            }
            List options = (List)AbstractMenuCommand.this._options.getValue();
            if (defaultOptionIndex >= options.size()) {
                throw new CommandDefinitionException("Default option is not selectable: " + defaultOptionIndex);
            }
            Option option = (Option)options.get(defaultOptionIndex);
            if (!(option instanceof SelectableOption)) {
                throw new CommandDefinitionException("Default option is not selectable: " + defaultOptionIndex);
            }
        }
    }

    private final class SymbolLengthLoader
    implements ValueLoader<Integer> {
        SymbolLengthLoader() {
        }

        @Override
        public Integer loadValue() {
            int symbolLength = AbstractMenuCommand.this.getSymbolLength();
            this.checkSymbolLengthPositive(symbolLength);
            return symbolLength;
        }

        private void checkSymbolLengthPositive(int symbolLength) {
            if (symbolLength <= 0) {
                throw new CommandDefinitionException("Symbol length is not positive: " + symbolLength);
            }
        }
    }

    private final class OptionsLoader
    implements ValueLoader<List<Option>> {
        OptionsLoader() {
        }

        @Override
        public List<Option> loadValue() {
            List<Option> options = AbstractMenuCommand.this.getOptions();
            this.checkOptionsDefined(options);
            this.checkOptionSymbolDefined(options);
            this.checkOptionSymbolUnique(options);
            this.checkOptionSymbolLength(options);
            this.checkOptionLabelDefined(options);
            return options;
        }

        private void checkOptionsDefined(List<Option> options) {
            if (options == null) {
                throw new CommandDefinitionException("Options are not defined");
            }
            boolean hasSelectableOption = false;
            for (Option option : options) {
                if (!(option instanceof SelectableOption)) continue;
                hasSelectableOption = true;
                break;
            }
            if (!hasSelectableOption) {
                throw new CommandDefinitionException("Options are not defined");
            }
        }

        private void checkOptionSymbolDefined(List<Option> options) {
            for (Option option : options) {
                if (!(option instanceof SelectableOption)) continue;
                String symbol = ((SelectableOption)option).getSymbol();
                if (symbol == null || AbstractMenuCommand.this.isDefaultInput(symbol)) {
                    throw new CommandDefinitionException("Option symbol is not defined");
                }
                String trimmedSymbol = symbol.trim();
                if (trimmedSymbol.equals(symbol)) continue;
                throw new CommandDefinitionException("Option symbol is wrong: " + symbol);
            }
        }

        private void checkOptionSymbolUnique(List<Option> options) {
            for (Option checkOption : options) {
                if (!(checkOption instanceof SelectableOption)) continue;
                for (Option option : options) {
                    String symbol;
                    if (option == checkOption || !(option instanceof SelectableOption) || !((SelectableOption)option).isSelected(symbol = ((SelectableOption)checkOption).getSymbol())) continue;
                    throw new CommandDefinitionException("Option symbol is not unique: " + symbol);
                }
            }
        }

        private void checkOptionSymbolLength(List<Option> options) {
            int symbolLength = (Integer)AbstractMenuCommand.this._symbolLength.getValue();
            for (Option option : options) {
                String symbol;
                if (!(option instanceof SelectableOption) || (symbol = ((SelectableOption)option).getSymbol()).length() <= symbolLength) continue;
                throw new CommandDefinitionException("Option symbol length is too large: " + symbol);
            }
        }

        private void checkOptionLabelDefined(List<Option> options) {
            for (Option option : options) {
                Lines label;
                if (!(option instanceof SelectableOption) || (label = ((SelectableOption)option).getLabel()) != null) continue;
                throw new CommandDefinitionException("Option label is not defined");
            }
        }
    }

    private final class HeaderLoader
    implements ValueLoader<Lines> {
        HeaderLoader() {
        }

        @Override
        public Lines loadValue() {
            Lines header = AbstractMenuCommand.this.getHeader();
            this.checkHeaderDefined(header);
            return header;
        }

        private void checkHeaderDefined(Lines header) {
            if (header == null) {
                throw new CommandDefinitionException("Header is not defined");
            }
        }
    }
}

