/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.command.menu;

import java.io.PrintWriter;
import java.util.List;
import ru.d_shap.cli.Command;
import ru.d_shap.cli.command.menu.SelectableOption;
import ru.d_shap.cli.data.Lines;

public final class MenuItem
implements SelectableOption {
    private final String _symbol;
    private final Lines _label;
    private final Command _command;

    public MenuItem(String symbol, String label) {
        this(symbol, new Lines(label), null);
    }

    public MenuItem(String symbol, Lines label) {
        this(symbol, label, null);
    }

    public MenuItem(String symbol, String label, Command command) {
        this(symbol, new Lines(label), command);
    }

    public MenuItem(String symbol, Lines label, Command command) {
        this._symbol = symbol;
        this._label = label == null ? new Lines() : label;
        this._command = command;
    }

    @Override
    public String getSymbol() {
        return this._symbol;
    }

    @Override
    public Lines getLabel() {
        return this._label;
    }

    @Override
    public void print(PrintWriter writer, int length, boolean isDefault) {
        String firstLinePattern = "%" + length + "s: %s";
        String nextLinesPattern = "%" + length + "s  %s";
        String symbol = this._symbol == null ? "" : this._symbol;
        if (isDefault) {
            symbol = "*" + symbol;
        }
        List<String> lines = this._label.getLines();
        boolean firstLine = true;
        for (String line : lines) {
            String str;
            if (firstLine) {
                str = String.format(firstLinePattern, symbol, line);
                firstLine = false;
            } else {
                str = String.format(nextLinesPattern, "", line);
            }
            writer.println(str);
        }
    }

    @Override
    public boolean isSelected(String symbol) {
        return this._symbol != null && this._symbol.equalsIgnoreCase(symbol);
    }

    @Override
    public Command getCommand() {
        return this._command;
    }
}

