/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class Context {
    private final Map<String, Object> _values;

    public Context() {
        this(null);
    }

    public Context(Context context) {
        this._values = context == null ? new TreeMap<String, Object>() : new TreeMap<String, Object>(context._values);
    }

    public List<String> getNames() {
        return new ArrayList<String>(this._values.keySet());
    }

    public boolean hasValue(String name) {
        if (name == null) {
            return false;
        }
        return this._values.containsKey(name);
    }

    public <T> T getValue(String name) {
        if (name == null) {
            return null;
        }
        return (T)this._values.get(name);
    }

    public <T> void putValue(String name, T value) {
        if (name != null) {
            this._values.put(name, value);
        }
    }

    public void removeValue(String name) {
        if (name != null) {
            this._values.remove(name);
        }
    }

    public void copyValueTo(String name, Context context) {
        this.copyValueTo(name, context, name);
    }

    public void copyValueTo(String name, Context context, String contextName) {
        if (this.hasValue(name)) {
            Object value = this.getValue(name);
            context.putValue(contextName, value);
        } else {
            context.removeValue(contextName);
        }
    }

    public String toString() {
        return this._values.keySet().toString();
    }
}

