/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Lines {
    private final List<String> _lines = new ArrayList<String>();

    public Lines() {
        this((Lines)null);
    }

    public Lines(String line) {
        this((Lines)null, line);
    }

    public Lines(String ... lines) {
        this((Lines)null, lines);
    }

    public Lines(Collection<String> lines) {
        this(null, lines);
    }

    public Lines(Lines base) {
        if (base != null) {
            this._lines.addAll(base._lines);
        }
    }

    public Lines(Lines base, String line) {
        this(base);
        this.addLine(line);
    }

    public Lines(Lines base, String ... lines) {
        this(base);
        this.addLines(lines);
    }

    public Lines(Lines base, Collection<String> lines) {
        this(base);
        this.addLines(lines);
    }

    public void addLine(String line) {
        if (line != null) {
            this._lines.add(line);
        }
    }

    public void addLines(String ... lines) {
        if (lines != null) {
            for (String line : lines) {
                this.addLine(line);
            }
        }
    }

    public void addLines(Collection<String> lines) {
        if (lines != null) {
            for (String line : lines) {
                this.addLine(line);
            }
        }
    }

    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>(this._lines);
        if (lines.isEmpty()) {
            lines.add("");
        }
        return lines;
    }

    public String toString() {
        return this._lines.toString();
    }
}

