/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class InputStreamWrapper
extends InputStream {
    private final InputStream _inputStream;
    private final OutputStream _logOutputStream;

    public InputStreamWrapper(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamWrapper(InputStream inputStream, OutputStream logOutputStream) {
        this._inputStream = inputStream;
        this._logOutputStream = logOutputStream;
    }

    @Override
    public int read() throws IOException {
        int value = this._inputStream.read();
        if (value >= 0 && this._logOutputStream != null) {
            this._logOutputStream.write(value);
        }
        return value;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int result = this._inputStream.read(buffer);
        if (result > 0 && this._logOutputStream != null) {
            this._logOutputStream.write(buffer, 0, result);
        }
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result = this._inputStream.read(buffer, offset, length);
        if (result > 0 && this._logOutputStream != null) {
            this._logOutputStream.write(buffer, offset, result);
        }
        return result;
    }

    @Override
    public long skip(long count) throws IOException {
        return this._inputStream.skip(count);
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void close() throws IOException {
        IOException exception;
        block6: {
            exception = null;
            try {
                this._inputStream.close();
            }
            catch (IOException ex) {
                exception = ex;
            }
            if (this._logOutputStream != null) {
                try {
                    this._logOutputStream.close();
                }
                catch (IOException ex) {
                    if (exception != null) break block6;
                    exception = ex;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

