/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.cli.io;

import java.io.IOException;
import java.io.OutputStream;

public final class OutputStreamWrapper
extends OutputStream {
    private final OutputStream _outputStream;
    private final OutputStream _logOutputStream;

    public OutputStreamWrapper(OutputStream outputStream) {
        this(outputStream, null);
    }

    public OutputStreamWrapper(OutputStream outputStream, OutputStream logOutputStream) {
        this._outputStream = outputStream;
        this._logOutputStream = logOutputStream;
    }

    @Override
    public void write(int value) throws IOException {
        this._outputStream.write(value);
        if (this._logOutputStream != null) {
            this._logOutputStream.write(value);
        }
    }

    @Override
    public void write(byte[] value) throws IOException {
        this._outputStream.write(value);
        if (this._logOutputStream != null) {
            this._logOutputStream.write(value);
        }
    }

    @Override
    public void write(byte[] value, int offset, int length) throws IOException {
        this._outputStream.write(value, offset, length);
        if (this._logOutputStream != null) {
            this._logOutputStream.write(value, offset, length);
        }
    }

    @Override
    public void flush() throws IOException {
        this._outputStream.flush();
        if (this._logOutputStream != null) {
            this._logOutputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception;
        block6: {
            exception = null;
            try {
                this._outputStream.close();
            }
            catch (IOException ex) {
                exception = ex;
            }
            if (this._logOutputStream != null) {
                try {
                    this._logOutputStream.close();
                }
                catch (IOException ex) {
                    if (exception != null) break block6;
                    exception = ex;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

