/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Arrays;

public final class Hash {
    private final MessageDigest _messageDigest;
    private byte[] _currentHash;

    Hash(MessageDigest messageDigest) {
        this._messageDigest = messageDigest;
        this._currentHash = this._messageDigest.digest();
    }

    public int getLength() {
        return this._currentHash.length;
    }

    public Hash addSalt(byte[] salt) {
        if (salt == null) {
            throw new IllegalArgumentException("Salt byte array is null");
        }
        this._messageDigest.update(this._currentHash);
        this._messageDigest.update(salt);
        this._currentHash = this._messageDigest.digest();
        return this;
    }

    public Hash addSalt(CharSequence salt) {
        return this.addSalt(salt, "UTF-8");
    }

    public Hash addSalt(CharSequence salt, String encoding) {
        if (salt == null) {
            throw new IllegalArgumentException("Salt char sequence is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Salt char sequence encoding is null");
        }
        try {
            byte[] saltBytes = salt.toString().getBytes(encoding);
            return this.addSalt(saltBytes);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Wrong salt char sequence encoding: " + encoding, ex);
        }
    }

    public byte[] getBytes() {
        byte[] result = new byte[this._currentHash.length];
        System.arraycopy(this._currentHash, 0, result, 0, this._currentHash.length);
        return result;
    }

    public boolean matches(byte[] hash) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash byte array is null");
        }
        return Arrays.equals(this._currentHash, hash);
    }
}

