/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import ru.d_shap.hash.Hash;
import ru.d_shap.hash.HashIOException;
import ru.d_shap.hash.SaltOrder;
import ru.d_shap.hash.SaltStoreType;

public final class HashHelper {
    private static final int INPUT_STREAM_BUFFER_SIZE = 512;

    private HashHelper() {
    }

    public static Hash getHash(byte[] bytes, String algorithm) {
        if (bytes == null) {
            throw new IllegalArgumentException("Source byte array is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm is null");
        }
        MessageDigest messageDigest = HashHelper.createMessageDigest(algorithm);
        HashHelper.updateMessageDigest(messageDigest, bytes);
        return new Hash(messageDigest);
    }

    public static Hash getHash(CharSequence charSequence, String algorithm) {
        return HashHelper.getHash(charSequence, "UTF-8", algorithm);
    }

    public static Hash getHash(CharSequence charSequence, String encoding, String algorithm) {
        if (charSequence == null) {
            throw new IllegalArgumentException("Source char sequence is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Source char sequence encoding is null");
        }
        try {
            byte[] charSequenceBytes = charSequence.toString().getBytes(encoding);
            return HashHelper.getHash(charSequenceBytes, algorithm);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Wrong source char sequence encoding: " + encoding, ex);
        }
    }

    public static Hash getHash(InputStream stream, String algorithm) {
        if (stream == null) {
            throw new IllegalArgumentException("Source stream is null");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm is null");
        }
        MessageDigest messageDigest = HashHelper.createMessageDigest(algorithm);
        HashHelper.updateMessageDigest(messageDigest, stream);
        return new Hash(messageDigest);
    }

    private static MessageDigest createMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Wrong algorithm name: " + algorithm, ex);
        }
    }

    private static void updateMessageDigest(MessageDigest messageDigest, byte[] bytes) {
        messageDigest.update(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMessageDigest(MessageDigest messageDigest, InputStream stream) {
        try {
            try {
                int read;
                byte[] buffer = new byte[512];
                while ((read = stream.read(buffer)) > 0) {
                    messageDigest.update(buffer, 0, read);
                }
            }
            finally {
                stream.close();
            }
        }
        catch (IOException ex) {
            throw new HashIOException(ex);
        }
    }

    public static void addSalt(Hash hash, byte[] storedSalt, byte[] fixedSalt, SaltOrder saltOrder) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash is null");
        }
        if (storedSalt == null) {
            throw new IllegalArgumentException("Stored salt is null");
        }
        if (fixedSalt == null) {
            throw new IllegalArgumentException("Fixed salt is null");
        }
        if (saltOrder == null) {
            throw new IllegalArgumentException("Salt order is null");
        }
        saltOrder.addSalt(hash, storedSalt, fixedSalt);
    }

    public static byte[] addSaltBytes(byte[] hash, byte[] salt, SaltStoreType saltStoreType) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash byte array is null");
        }
        if (salt == null) {
            throw new IllegalArgumentException("Salt byte array is null");
        }
        if (saltStoreType == null) {
            throw new IllegalArgumentException("Salt store type is null");
        }
        return saltStoreType.addSaltBytes(hash, salt);
    }

    public static byte[] getHashBytes(byte[] bytes, SaltStoreType saltStoreType, int saltLength) {
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (saltStoreType == null) {
            throw new IllegalArgumentException("Salt store type is null");
        }
        if (saltLength < 0 || saltLength >= bytes.length) {
            throw new IllegalArgumentException("Salt length is not within [0; " + bytes.length + ")");
        }
        return saltStoreType.getHashBytes(bytes, saltLength);
    }

    public static byte[] getSaltBytes(byte[] bytes, SaltStoreType saltStoreType, int saltLength) {
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (saltStoreType == null) {
            throw new IllegalArgumentException("Salt store type is null");
        }
        if (saltLength < 0 || saltLength >= bytes.length) {
            throw new IllegalArgumentException("Salt length is not within [0; " + bytes.length + ")");
        }
        return saltStoreType.getSaltBytes(bytes, saltLength);
    }
}

