/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash;

public enum SaltStoreType {
    DO_NOT_STORE{

        @Override
        byte[] addSaltBytes(byte[] hash, byte[] salt) {
            byte[] result = new byte[hash.length];
            System.arraycopy(hash, 0, result, 0, hash.length);
            return result;
        }

        @Override
        byte[] getSaltBytes(byte[] bytes, int saltLength) {
            return new byte[0];
        }

        @Override
        byte[] getHashBytes(byte[] bytes, int saltLength) {
            byte[] result = new byte[bytes.length];
            System.arraycopy(bytes, 0, result, 0, bytes.length);
            return result;
        }
    }
    ,
    AT_THE_BEGINNING{

        @Override
        byte[] addSaltBytes(byte[] hash, byte[] salt) {
            byte[] result = new byte[hash.length + salt.length];
            System.arraycopy(salt, 0, result, 0, salt.length);
            System.arraycopy(hash, 0, result, salt.length, hash.length);
            return result;
        }

        @Override
        byte[] getSaltBytes(byte[] bytes, int saltLength) {
            byte[] salt = new byte[saltLength];
            System.arraycopy(bytes, 0, salt, 0, saltLength);
            return salt;
        }

        @Override
        byte[] getHashBytes(byte[] bytes, int saltLength) {
            int hashLength = bytes.length - saltLength;
            byte[] hash = new byte[hashLength];
            System.arraycopy(bytes, saltLength, hash, 0, hashLength);
            return hash;
        }
    }
    ,
    AT_THE_END{

        @Override
        byte[] addSaltBytes(byte[] hash, byte[] salt) {
            byte[] result = new byte[hash.length + salt.length];
            System.arraycopy(hash, 0, result, 0, hash.length);
            System.arraycopy(salt, 0, result, hash.length, salt.length);
            return result;
        }

        @Override
        byte[] getSaltBytes(byte[] bytes, int saltLength) {
            byte[] salt = new byte[saltLength];
            System.arraycopy(bytes, bytes.length - saltLength, salt, 0, saltLength);
            return salt;
        }

        @Override
        byte[] getHashBytes(byte[] bytes, int saltLength) {
            int hashLength = bytes.length - saltLength;
            byte[] hash = new byte[hashLength];
            System.arraycopy(bytes, 0, hash, 0, hashLength);
            return hash;
        }
    };


    abstract byte[] addSaltBytes(byte[] var1, byte[] var2);

    abstract byte[] getSaltBytes(byte[] var1, int var2);

    abstract byte[] getHashBytes(byte[] var1, int var2);
}

