/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash.builder;

import ru.d_shap.hash.Hash;
import ru.d_shap.hash.HashHelper;
import ru.d_shap.hash.SaltStoreType;

abstract class AbstractHashBuilder<T extends AbstractHashBuilder> {
    private String _algorithm = "MD5";
    private byte[] _storedHash = null;

    AbstractHashBuilder() {
    }

    public final String getAlgorithm() {
        return this._algorithm;
    }

    public final T setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
        return (T)this;
    }

    public abstract byte[] getHash();

    public final byte[] getStoredHash() {
        if (this._storedHash == null) {
            return null;
        }
        byte[] result = new byte[this._storedHash.length];
        System.arraycopy(this._storedHash, 0, result, 0, this._storedHash.length);
        return result;
    }

    public final T setStoredHash(byte[] storedHash) {
        if (storedHash == null) {
            this._storedHash = null;
        } else {
            this._storedHash = new byte[storedHash.length];
            System.arraycopy(storedHash, 0, this._storedHash, 0, storedHash.length);
        }
        return (T)this;
    }

    final int getStoredSaltLength(int hashLength) {
        if (this._storedHash == null) {
            throw new IllegalArgumentException("Stored hash is null");
        }
        return this._storedHash.length - hashLength;
    }

    final boolean matches(Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash is null");
        }
        return hash.matches(this._storedHash);
    }

    final byte[] getHashFromStoredHash(SaltStoreType saltStoreType, int storedSaltLength) {
        return HashHelper.getHashBytes(this._storedHash, saltStoreType, storedSaltLength);
    }

    final byte[] getSaltFromStoredHash(SaltStoreType saltStoreType, int storedSaltLength) {
        return HashHelper.getSaltBytes(this._storedHash, saltStoreType, storedSaltLength);
    }

    public abstract boolean isHashValid();
}

