/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash.builder;

import ru.d_shap.hash.Hash;
import ru.d_shap.hash.HashHelper;
import ru.d_shap.hash.SaltStoreType;
import ru.d_shap.hash.builder.HashWithSaltBuilder;

final class ByteArrayHashWithSaltBuilder
extends HashWithSaltBuilder {
    private final byte[] _bytes;

    ByteArrayHashWithSaltBuilder(byte[] bytes) {
        this._bytes = bytes;
    }

    @Override
    public byte[] getHash() {
        Hash hash = this.addSalt(HashHelper.getHash(this._bytes, this.getAlgorithm()));
        return this.addSaltBytes(hash);
    }

    @Override
    public boolean isHashValid() {
        if (this.getSaltStoreType() == SaltStoreType.DO_NOT_STORE) {
            return this.matches(this.addSalt(HashHelper.getHash(this._bytes, this.getAlgorithm())));
        }
        Hash hash = HashHelper.getHash(this._bytes, this.getAlgorithm());
        int storedSaltLength = this.getStoredSaltLength(hash.getLength());
        byte[] storedHash = this.getHashFromStoredHash(this.getSaltStoreType(), storedSaltLength);
        byte[] storedSalt = this.getSaltFromStoredHash(this.getSaltStoreType(), storedSaltLength);
        return hash.addSalt(storedSalt).matches(storedHash);
    }
}

