/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash.builder;

import ru.d_shap.hash.Hash;
import ru.d_shap.hash.HashHelper;
import ru.d_shap.hash.SaltStoreType;
import ru.d_shap.hash.builder.HashWithSalt2Builder;

final class CharSequenceHashWithSalt2Builder
extends HashWithSalt2Builder {
    private final CharSequence _charSequence;
    private final String _encoding;

    CharSequenceHashWithSalt2Builder(CharSequence charSequence, String encoding) {
        this._charSequence = charSequence;
        this._encoding = encoding;
    }

    @Override
    public byte[] getHash() {
        Hash hash = this.addSalt(HashHelper.getHash(this._charSequence, this._encoding, this.getAlgorithm()));
        return this.addSaltBytes(hash);
    }

    @Override
    public boolean isHashValid() {
        if (this.getSaltStoreType() == SaltStoreType.DO_NOT_STORE) {
            return this.matches(this.addSalt(HashHelper.getHash(this._charSequence, this._encoding, this.getAlgorithm())));
        }
        Hash hash = HashHelper.getHash(this._charSequence, this._encoding, this.getAlgorithm());
        int storedSaltLength = this.getStoredSaltLength(hash.getLength());
        byte[] storedHash = this.getHashFromStoredHash(this.getSaltStoreType(), storedSaltLength);
        byte[] storedSalt = this.getSaltFromStoredHash(this.getSaltStoreType(), storedSaltLength);
        return this.addSalt(hash, storedSalt).matches(storedHash);
    }
}

