/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash.builder;

import java.io.InputStream;
import ru.d_shap.hash.builder.ByteArrayHashWithSalt2Builder;
import ru.d_shap.hash.builder.ByteArrayHashWithSaltBuilder;
import ru.d_shap.hash.builder.ByteArraySimpleHashBuilder;
import ru.d_shap.hash.builder.CharSequenceHashWithSalt2Builder;
import ru.d_shap.hash.builder.CharSequenceHashWithSaltBuilder;
import ru.d_shap.hash.builder.CharSequenceSimpleHashBuilder;
import ru.d_shap.hash.builder.HashWithSalt2Builder;
import ru.d_shap.hash.builder.HashWithSaltBuilder;
import ru.d_shap.hash.builder.InputStreamHashWithSalt2Builder;
import ru.d_shap.hash.builder.InputStreamHashWithSaltBuilder;
import ru.d_shap.hash.builder.InputStreamSimpleHashBuilder;
import ru.d_shap.hash.builder.SimpleHashBuilder;

public final class HashBuilder {
    private HashBuilder() {
    }

    public static SimpleHashBuilder newSimpleHashBuilder(byte[] bytes) {
        return new ByteArraySimpleHashBuilder(bytes);
    }

    public static SimpleHashBuilder newSimpleHashBuilder(CharSequence charSequence) {
        return HashBuilder.newSimpleHashBuilder(charSequence, "UTF-8");
    }

    public static SimpleHashBuilder newSimpleHashBuilder(CharSequence charSequence, String encoding) {
        return new CharSequenceSimpleHashBuilder(charSequence, encoding);
    }

    public static SimpleHashBuilder newSimpleHashBuilder(InputStream stream) {
        return new InputStreamSimpleHashBuilder(stream);
    }

    public static HashWithSaltBuilder newHashWithSaltBuilder(byte[] bytes) {
        return new ByteArrayHashWithSaltBuilder(bytes);
    }

    public static HashWithSaltBuilder newHashWithSaltBuilder(CharSequence charSequence) {
        return HashBuilder.newHashWithSaltBuilder(charSequence, "UTF-8");
    }

    public static HashWithSaltBuilder newHashWithSaltBuilder(CharSequence charSequence, String encoding) {
        return new CharSequenceHashWithSaltBuilder(charSequence, encoding);
    }

    public static HashWithSaltBuilder newHashWithSaltBuilder(InputStream stream) {
        return new InputStreamHashWithSaltBuilder(stream);
    }

    public static HashWithSalt2Builder newHashWithSalt2Builder(byte[] bytes) {
        return new ByteArrayHashWithSalt2Builder(bytes);
    }

    public static HashWithSalt2Builder newHashWithSalt2Builder(CharSequence charSequence) {
        return HashBuilder.newHashWithSalt2Builder(charSequence, "UTF-8");
    }

    public static HashWithSalt2Builder newHashWithSalt2Builder(CharSequence charSequence, String encoding) {
        return new CharSequenceHashWithSalt2Builder(charSequence, encoding);
    }

    public static HashWithSalt2Builder newHashWithSalt2Builder(InputStream stream) {
        return new InputStreamHashWithSalt2Builder(stream);
    }
}

