/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash.builder;

import ru.d_shap.hash.Hash;
import ru.d_shap.hash.HashHelper;
import ru.d_shap.hash.SaltOrder;
import ru.d_shap.hash.SaltStoreType;
import ru.d_shap.hash.builder.AbstractHashBuilder;

public abstract class HashWithSalt2Builder
extends AbstractHashBuilder<HashWithSalt2Builder> {
    private byte[] _storedSalt = null;
    private byte[] _fixedSalt = null;
    private SaltOrder _saltOrder = SaltOrder.STORED_SALT_FIRST;
    private SaltStoreType _saltStoreType = SaltStoreType.DO_NOT_STORE;

    HashWithSalt2Builder() {
    }

    public final byte[] getStoredSalt() {
        if (this._storedSalt == null) {
            return null;
        }
        byte[] result = new byte[this._storedSalt.length];
        System.arraycopy(this._storedSalt, 0, result, 0, this._storedSalt.length);
        return result;
    }

    public final HashWithSalt2Builder setStoredSalt(byte[] storedSalt) {
        if (storedSalt == null) {
            this._storedSalt = null;
        } else {
            this._storedSalt = new byte[storedSalt.length];
            System.arraycopy(storedSalt, 0, this._storedSalt, 0, storedSalt.length);
        }
        return this;
    }

    public final byte[] getFixedSalt() {
        if (this._fixedSalt == null) {
            return null;
        }
        byte[] result = new byte[this._fixedSalt.length];
        System.arraycopy(this._fixedSalt, 0, result, 0, this._fixedSalt.length);
        return result;
    }

    public final HashWithSalt2Builder setFixedSalt(byte[] fixedSalt) {
        if (fixedSalt == null) {
            this._fixedSalt = null;
        } else {
            this._fixedSalt = new byte[fixedSalt.length];
            System.arraycopy(fixedSalt, 0, this._fixedSalt, 0, fixedSalt.length);
        }
        return this;
    }

    final Hash addSalt(Hash hash) {
        HashHelper.addSalt(hash, this._storedSalt, this._fixedSalt, this._saltOrder);
        return hash;
    }

    final Hash addSalt(Hash hash, byte[] storedSalt) {
        HashHelper.addSalt(hash, storedSalt, this._fixedSalt, this._saltOrder);
        return hash;
    }

    final byte[] addSaltBytes(Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash is null");
        }
        return HashHelper.addSaltBytes(hash.getBytes(), this._storedSalt, this._saltStoreType);
    }

    public final SaltOrder getSaltOrder() {
        return this._saltOrder;
    }

    public final HashWithSalt2Builder setSaltOrder(SaltOrder saltOrder) {
        this._saltOrder = saltOrder;
        return this;
    }

    public final SaltStoreType getSaltStoreType() {
        return this._saltStoreType;
    }

    public final HashWithSalt2Builder setSaltStoreType(SaltStoreType saltStoreType) {
        this._saltStoreType = saltStoreType;
        return this;
    }
}

