/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash.builder;

import ru.d_shap.hash.Hash;
import ru.d_shap.hash.HashHelper;
import ru.d_shap.hash.SaltStoreType;
import ru.d_shap.hash.builder.AbstractHashBuilder;

public abstract class HashWithSaltBuilder
extends AbstractHashBuilder<HashWithSaltBuilder> {
    private byte[] _salt = null;
    private SaltStoreType _saltStoreType = SaltStoreType.DO_NOT_STORE;

    HashWithSaltBuilder() {
    }

    public final byte[] getSalt() {
        if (this._salt == null) {
            return null;
        }
        byte[] result = new byte[this._salt.length];
        System.arraycopy(this._salt, 0, result, 0, this._salt.length);
        return result;
    }

    public final HashWithSaltBuilder setSalt(byte[] salt) {
        if (salt == null) {
            this._salt = null;
        } else {
            this._salt = new byte[salt.length];
            System.arraycopy(salt, 0, this._salt, 0, salt.length);
        }
        return this;
    }

    final Hash addSalt(Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash is null");
        }
        hash.addSalt(this._salt);
        return hash;
    }

    final byte[] addSaltBytes(Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash is null");
        }
        return HashHelper.addSaltBytes(hash.getBytes(), this._salt, this._saltStoreType);
    }

    public final SaltStoreType getSaltStoreType() {
        return this._saltStoreType;
    }

    public final HashWithSaltBuilder setSaltStoreType(SaltStoreType saltStoreType) {
        this._saltStoreType = saltStoreType;
        return this;
    }
}

