/*
 * Decompiled with CFR 0.152.
 */
package ru.d_shap.hash.builder;

import java.io.InputStream;
import ru.d_shap.hash.Hash;
import ru.d_shap.hash.HashHelper;
import ru.d_shap.hash.SaltStoreType;
import ru.d_shap.hash.builder.HashWithSalt2Builder;

final class InputStreamHashWithSalt2Builder
extends HashWithSalt2Builder {
    private final InputStream _stream;

    InputStreamHashWithSalt2Builder(InputStream stream) {
        this._stream = stream;
    }

    @Override
    public byte[] getHash() {
        Hash hash = this.addSalt(HashHelper.getHash(this._stream, this.getAlgorithm()));
        return this.addSaltBytes(hash);
    }

    @Override
    public boolean isHashValid() {
        if (this.getSaltStoreType() == SaltStoreType.DO_NOT_STORE) {
            return this.matches(this.addSalt(HashHelper.getHash(this._stream, this.getAlgorithm())));
        }
        Hash hash = HashHelper.getHash(this._stream, this.getAlgorithm());
        int storedSaltLength = this.getStoredSaltLength(hash.getLength());
        byte[] storedHash = this.getHashFromStoredHash(this.getSaltStoreType(), storedSaltLength);
        byte[] storedSalt = this.getSaltFromStoredHash(this.getSaltStoreType(), storedSaltLength);
        return this.addSalt(hash, storedSalt).matches(storedHash);
    }
}

